/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GrokProcessorGetAction {
    static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/ingest/processor/grok/get");

    private GrokProcessorGetAction() {
    }

    @ServerlessScope(value=Scope.PUBLIC)
    public static class RestAction
    extends BaseRestHandler {
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/processor/grok"));
        }

        public String getName() {
            return "ingest_processor_grok_get";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
            boolean sorted = request.paramAsBoolean("s", false);
            String ecsCompatibility = request.param("ecs_compatibility", "disabled");
            if (!GrokBuiltinPatterns.isValidEcsCompatibilityMode((String)ecsCompatibility)) {
                throw new IllegalArgumentException("unsupported ECS compatibility mode [" + ecsCompatibility + "]");
            }
            Request grokPatternsRequest = new Request(sorted, ecsCompatibility);
            return channel -> client.executeLocally(INSTANCE, (ActionRequest)grokPatternsRequest, (ActionListener)new RestToXContentListener(channel));
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Map<String, String> legacyGrokPatterns;
        private final Map<String, String> sortedLegacyGrokPatterns;
        private final Map<String, String> ecsV1GrokPatterns;
        private final Map<String, String> sortedEcsV1GrokPatterns;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters) {
            this(transportService, actionFilters, GrokBuiltinPatterns.legacyPatterns(), GrokBuiltinPatterns.ecsV1Patterns());
        }

        TransportAction(TransportService transportService, ActionFilters actionFilters, PatternBank legacyGrokPatterns, PatternBank ecsV1GrokPatterns) {
            super(INSTANCE.name(), transportService, actionFilters, Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.legacyGrokPatterns = legacyGrokPatterns.bank();
            this.sortedLegacyGrokPatterns = new TreeMap<String, String>(this.legacyGrokPatterns);
            this.ecsV1GrokPatterns = ecsV1GrokPatterns.bank();
            this.sortedEcsV1GrokPatterns = new TreeMap<String, String>(this.ecsV1GrokPatterns);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            ActionListener.completeWith(listener, () -> new Response(request.getEcsCompatibility().equals("disabled") ? (request.sorted() ? this.sortedLegacyGrokPatterns : this.legacyGrokPatterns) : (request.sorted() ? this.sortedEcsV1GrokPatterns : this.ecsV1GrokPatterns)));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Map<String, String> grokPatterns;

        Response(Map<String, String> grokPatterns) {
            this.grokPatterns = grokPatterns;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.grokPatterns = in.readMap(StreamInput::readString);
        }

        public Map<String, String> getGrokPatterns() {
            return this.grokPatterns;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("patterns");
            builder.map(this.grokPatterns);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.grokPatterns, StreamOutput::writeString);
        }
    }

    public static class Request
    extends LegacyActionRequest {
        private final boolean sorted;
        private final String ecsCompatibility;

        public Request(boolean sorted, String ecsCompatibility) {
            this.sorted = sorted;
            this.ecsCompatibility = ecsCompatibility;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.sorted = in.readBoolean();
            this.ecsCompatibility = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0) ? in.readString() : "disabled";
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.sorted);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0)) {
                out.writeString(this.ecsCompatibility);
            }
        }

        public boolean sorted() {
            return this.sorted;
        }

        public String getEcsCompatibility() {
            return this.ecsCompatibility;
        }
    }
}

