/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.h3.H3;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.common.H3CartesianUtil;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoHexGridAggregationBuilder;
import org.elasticsearch.xpack.vectortile.feature.FeatureFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum GridAggregation {
    GEOTILE{

        @Override
        public GeoGridAggregationBuilder newAgg(String aggName) {
            return new GeoTileGridAggregationBuilder(aggName);
        }

        @Override
        public Rectangle bufferTile(Rectangle tile, int z, int gridPrecision) {
            return tile;
        }

        @Override
        public int gridPrecisionToAggPrecision(int z, int gridPrecision) {
            return Math.min(29, z + gridPrecision);
        }

        @Override
        public byte[] toGrid(String bucketKey, FeatureFactory featureFactory) throws IOException {
            Rectangle r = this.toRectangle(bucketKey);
            return featureFactory.box(r.getMinLon(), r.getMaxLon(), r.getMinLat(), r.getMaxLat());
        }

        @Override
        public Rectangle toRectangle(String bucketKey) {
            return GeoTileUtils.toBoundingBox((String)bucketKey);
        }

        @Override
        public boolean needsBounding(int z, int gridPrecision) {
            return true;
        }
    }
    ,
    GEOHEX{
        private static final double[] LAT_BUFFER_SIZE = new double[16];
        private static final double[] LON_BUFFER_SIZE = new double[16];
        private static final int[] ZOOM2RESOLUTION;

        @Override
        public GeoGridAggregationBuilder newAgg(String aggName) {
            return new GeoHexGridAggregationBuilder(aggName);
        }

        @Override
        public Rectangle bufferTile(Rectangle tile, int z, int gridPrecision) {
            if (z == 0 || gridPrecision == 0) {
                return tile;
            }
            int aggPrecision = this.gridPrecisionToAggPrecision(z, gridPrecision);
            if (aggPrecision < 2) {
                return new Rectangle(-180.0, 180.0, 85.0511287798066, -85.0511287798066);
            }
            return new Rectangle(GeoUtils.normalizeLon((double)(tile.getMinX() - LON_BUFFER_SIZE[aggPrecision])), GeoUtils.normalizeLon((double)(tile.getMaxX() + LON_BUFFER_SIZE[aggPrecision])), Math.min(85.0511287798066, tile.getMaxY() + LAT_BUFFER_SIZE[aggPrecision]), Math.max(-85.0511287798066, tile.getMinY() - LAT_BUFFER_SIZE[aggPrecision]));
        }

        @Override
        public int gridPrecisionToAggPrecision(int z, int gridPrecision) {
            return ZOOM2RESOLUTION[GEOTILE.gridPrecisionToAggPrecision(z, gridPrecision)];
        }

        @Override
        public byte[] toGrid(String bucketKey, FeatureFactory featureFactory) {
            List<byte[]> x = featureFactory.getFeatures(H3CartesianUtil.getNormalizeGeometry((long)H3.stringToH3((String)bucketKey)));
            return x.size() > 0 ? x.get(0) : null;
        }

        @Override
        public Rectangle toRectangle(String bucketKey) {
            return H3CartesianUtil.toBoundingBox((long)H3.stringToH3((String)bucketKey));
        }

        @Override
        public boolean needsBounding(int z, int gridPrecision) {
            return this.gridPrecisionToAggPrecision(z, gridPrecision) > 3;
        }

        static {
            2.LAT_BUFFER_SIZE[1] = Double.NaN;
            2.LAT_BUFFER_SIZE[0] = Double.NaN;
            2.LON_BUFFER_SIZE[1] = Double.NaN;
            2.LON_BUFFER_SIZE[0] = Double.NaN;
            2.LAT_BUFFER_SIZE[2] = 3.7;
            2.LON_BUFFER_SIZE[2] = 51.2;
            for (int i = 3; i < LON_BUFFER_SIZE.length; ++i) {
                2.LAT_BUFFER_SIZE[i] = LAT_BUFFER_SIZE[i - 1] / 2.5;
                2.LON_BUFFER_SIZE[i] = LON_BUFFER_SIZE[i - 1] / 2.5;
            }
            ZOOM2RESOLUTION = new int[]{0, 0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 14, 15, 15, 15, 15};
        }
    };


    public abstract GeoGridAggregationBuilder newAgg(String var1);

    public abstract Rectangle bufferTile(Rectangle var1, int var2, int var3);

    public abstract int gridPrecisionToAggPrecision(int var1, int var2);

    public abstract byte[] toGrid(String var1, FeatureFactory var2) throws IOException;

    public abstract Rectangle toRectangle(String var1);

    public abstract boolean needsBounding(int var1, int var2);

    public static GridAggregation fromString(String type) {
        return switch (type.toLowerCase(Locale.ROOT)) {
            case "geotile" -> GEOTILE;
            case "geohex" -> GEOHEX;
            default -> throw new IllegalArgumentException("Invalid agg type [" + type + "]");
        };
    }
}

