/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SamlInitiateSingleSignOnAttributes
implements Writeable,
ToXContentObject {
    private final Map<String, List<String>> attributes;

    public SamlInitiateSingleSignOnAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static SamlInitiateSingleSignOnAttributes fromXContent(XContentParser parser) throws IOException {
        Map attributes = parser.map(HashMap::new, p -> XContentParserUtils.parseList((XContentParser)p, XContentParser::text));
        return new SamlInitiateSingleSignOnAttributes(attributes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.attributes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.attributes, StreamOutput::writeStringCollection);
    }

    public SamlInitiateSingleSignOnAttributes(StreamInput in) throws IOException {
        this.attributes = in.readImmutableMap(StreamInput::readStringCollectionAsImmutableList);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                if (!Strings.isNullOrEmpty((String)key)) continue;
                validationException = ValidateActions.addValidationError((String)"attribute key cannot be null or empty", validationException);
            }
        }
        return validationException;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{attributes=" + this.attributes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlInitiateSingleSignOnAttributes that = (SamlInitiateSingleSignOnAttributes)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }
}

