/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.core.Nullable;

enum Database {
    City(Set.of(Property.IP, Property.COUNTRY_IN_EUROPEAN_UNION, Property.COUNTRY_ISO_CODE, Property.CONTINENT_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.TIMEZONE, Property.LOCATION, Property.POSTAL_CODE, Property.ACCURACY_RADIUS, Property.REGISTERED_COUNTRY_IN_EUROPEAN_UNION, Property.REGISTERED_COUNTRY_ISO_CODE, Property.REGISTERED_COUNTRY_NAME), Set.of(Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION)),
    Country(Set.of(Property.IP, Property.CONTINENT_CODE, Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_IN_EUROPEAN_UNION, Property.COUNTRY_ISO_CODE, Property.REGISTERED_COUNTRY_IN_EUROPEAN_UNION, Property.REGISTERED_COUNTRY_ISO_CODE, Property.REGISTERED_COUNTRY_NAME), Set.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE)),
    Asn(Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK), Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK)),
    AnonymousIp(Set.of(Property.IP, Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY), Set.of(Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY)),
    ConnectionType(Set.of(Property.IP, Property.CONNECTION_TYPE), Set.of(Property.CONNECTION_TYPE)),
    Domain(Set.of(Property.IP, Property.DOMAIN), Set.of(Property.DOMAIN)),
    Enterprise(Set.of(Property.IP, Property.COUNTRY_CONFIDENCE, Property.COUNTRY_IN_EUROPEAN_UNION, Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_CODE, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_CONFIDENCE, Property.CITY_NAME, Property.TIMEZONE, Property.LOCATION, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK, Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY, Property.DOMAIN, Property.ISP, Property.ISP_ORGANIZATION_NAME, Property.MOBILE_COUNTRY_CODE, Property.MOBILE_NETWORK_CODE, Property.USER_TYPE, Property.CONNECTION_TYPE, Property.POSTAL_CODE, Property.POSTAL_CONFIDENCE, Property.ACCURACY_RADIUS, Property.REGISTERED_COUNTRY_IN_EUROPEAN_UNION, Property.REGISTERED_COUNTRY_ISO_CODE, Property.REGISTERED_COUNTRY_NAME), Set.of(Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION)),
    Isp(Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK, Property.ISP, Property.ISP_ORGANIZATION_NAME, Property.MOBILE_COUNTRY_CODE, Property.MOBILE_NETWORK_CODE), Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK, Property.ISP, Property.ISP_ORGANIZATION_NAME, Property.MOBILE_COUNTRY_CODE, Property.MOBILE_NETWORK_CODE)),
    AsnV2(Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK, Property.DOMAIN, Property.COUNTRY_ISO_CODE, Property.TYPE), Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK)),
    CityV2(Set.of(Property.IP, Property.COUNTRY_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.TIMEZONE, Property.LOCATION, Property.POSTAL_CODE), Set.of(Property.COUNTRY_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION)),
    CountryV2(Set.of(Property.IP, Property.CONTINENT_CODE, Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE), Set.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE)),
    PrivacyDetection(Set.of(Property.IP, Property.HOSTING, Property.PROXY, Property.RELAY, Property.TOR, Property.VPN, Property.SERVICE), Set.of(Property.HOSTING, Property.PROXY, Property.RELAY, Property.TOR, Property.VPN, Property.SERVICE));

    private final Set<Property> properties;
    private final Set<Property> defaultProperties;

    private Database(Set<Property> properties, Set<Property> defaultProperties) {
        this.properties = properties;
        this.defaultProperties = defaultProperties;
    }

    public Set<Property> properties() {
        return this.properties;
    }

    public Set<Property> defaultProperties() {
        return this.defaultProperties;
    }

    public Set<Property> parseProperties(@Nullable List<String> propertyNames) {
        if (propertyNames != null) {
            HashSet<Property> parsedProperties = new HashSet<Property>();
            for (String propertyName : propertyNames) {
                parsedProperties.add(Property.parseProperty(this.properties, propertyName));
            }
            return Set.copyOf(parsedProperties);
        }
        return this.defaultProperties;
    }

    static enum Property {
        IP,
        COUNTRY_CONFIDENCE,
        COUNTRY_IN_EUROPEAN_UNION,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_CODE,
        CONTINENT_NAME,
        REGION_ISO_CODE,
        REGION_NAME,
        CITY_CONFIDENCE,
        CITY_NAME,
        TIMEZONE,
        LOCATION,
        ASN,
        ORGANIZATION_NAME,
        NETWORK,
        HOSTING_PROVIDER,
        TOR_EXIT_NODE,
        ANONYMOUS_VPN,
        ANONYMOUS,
        PUBLIC_PROXY,
        RESIDENTIAL_PROXY,
        DOMAIN,
        ISP,
        ISP_ORGANIZATION_NAME,
        MOBILE_COUNTRY_CODE,
        MOBILE_NETWORK_CODE,
        CONNECTION_TYPE,
        USER_TYPE,
        TYPE,
        POSTAL_CODE,
        POSTAL_CONFIDENCE,
        ACCURACY_RADIUS,
        HOSTING,
        TOR,
        PROXY,
        RELAY,
        VPN,
        SERVICE,
        REGISTERED_COUNTRY_IN_EUROPEAN_UNION,
        REGISTERED_COUNTRY_ISO_CODE,
        REGISTERED_COUNTRY_NAME;


        private static Property parseProperty(Set<Property> validProperties, String value) {
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                Property[] properties = validProperties.toArray(new Property[0]);
                Arrays.sort((Object[])properties);
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString((Object[])properties));
            }
        }
    }
}

