/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.QueryRule;

public class PutQueryRuleAction {
    public static final String NAME = "cluster:admin/xpack/query_rules/rule/put";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/query_rules/rule/put");

    private PutQueryRuleAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        final DocWriteResponse.Result result;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.result = DocWriteResponse.Result.readFrom((StreamInput)in);
        }

        public Response(DocWriteResponse.Result result) {
            this.result = result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.result.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result.getLowercase());
            builder.endObject();
            return builder;
        }

        public RestStatus status() {
            return switch (this.result) {
                case DocWriteResponse.Result.CREATED -> RestStatus.CREATED;
                case DocWriteResponse.Result.NOT_FOUND -> RestStatus.NOT_FOUND;
                default -> RestStatus.OK;
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final String queryRulesetId;
        private final QueryRule queryRule;
        private static final ParseField QUERY_RULESET_ID_FIELD = new ParseField("queryRulesetId", new String[0]);
        private static final ParseField QUERY_RULE_FIELD = new ParseField("queryRule", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_query_rule_request", p -> new Request((String)p[0], (QueryRule)p[1]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.queryRulesetId = in.readString();
            this.queryRule = new QueryRule(in);
        }

        public Request(String queryRulesetId, QueryRule queryRule) {
            this.queryRulesetId = queryRulesetId;
            this.queryRule = queryRule;
        }

        public Request(String rulesetId, String ruleId, BytesReference content, XContentType contentType) {
            this.queryRulesetId = rulesetId;
            QueryRule queryRule = QueryRule.fromXContentBytes(content, contentType);
            if (queryRule.id() == null) {
                this.queryRule = new QueryRule(ruleId, queryRule);
            } else {
                if (!ruleId.equals(queryRule.id())) {
                    throw new IllegalArgumentException("rule_id does not match the id in the query rule");
                }
                this.queryRule = queryRule;
            }
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.queryRulesetId)) {
                validationException = ValidateActions.addValidationError((String)"ruleset_id cannot be null or empty", validationException);
            }
            if (Strings.isNullOrEmpty((String)this.queryRule.id())) {
                validationException = ValidateActions.addValidationError((String)"rule_id cannot be null or empty", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.queryRulesetId);
            this.queryRule.writeTo(out);
        }

        public String queryRulesetId() {
            return this.queryRulesetId;
        }

        public QueryRule queryRule() {
            return this.queryRule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.queryRulesetId, request.queryRulesetId) && Objects.equals(this.queryRule, request.queryRule);
        }

        public int hashCode() {
            return Objects.hash(this.queryRulesetId, this.queryRule);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(QUERY_RULESET_ID_FIELD.getPreferredName(), this.queryRulesetId);
            builder.field(QUERY_RULE_FIELD.getPreferredName(), (ToXContent)this.queryRule);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser, String resourceName) {
            return (Request)((Object)PARSER.apply(parser, (Object)resourceName));
        }

        public static Request fromXContent(String queryRulesetId, XContentParser parser) throws IOException {
            return new Request(queryRulesetId, QueryRule.fromXContent(parser));
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_RULESET_ID_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRule.fromXContent(p), QUERY_RULE_FIELD);
        }
    }
}

