/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.action.ConnectorSyncJobActionRequest;

public class ClaimConnectorSyncJobAction {
    public static final ParseField CONNECTOR_SYNC_JOB_ID_FIELD = new ParseField("connector_sync_job_id", new String[0]);
    public static final String NAME = "indices:data/write/xpack/connector/sync_job/claim";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/sync_job/claim");

    private ClaimConnectorSyncJobAction() {
    }

    public static class Request
    extends ConnectorSyncJobActionRequest
    implements ToXContentObject {
        private final String connectorSyncJobId;
        private final String workerHostname;
        private final Object syncCursor;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("claim_connector_sync_job", false, (args, connectorSyncJobId) -> {
            String workerHostname = (String)args[0];
            Object syncCursor = args[1];
            return new Request((String)connectorSyncJobId, workerHostname, syncCursor);
        });

        public String getConnectorSyncJobId() {
            return this.connectorSyncJobId;
        }

        public String getWorkerHostname() {
            return this.workerHostname;
        }

        public Object getSyncCursor() {
            return this.syncCursor;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorSyncJobId = in.readString();
            this.workerHostname = in.readString();
            this.syncCursor = in.readGenericValue();
        }

        public Request(String connectorSyncJobId, String workerHostname, Object syncCursor) {
            this.connectorSyncJobId = connectorSyncJobId;
            this.workerHostname = workerHostname;
            this.syncCursor = syncCursor;
        }

        public static Request fromXContent(XContentParser parser, String connectorSyncJobId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorSyncJobId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ConnectorSyncJob.WORKER_HOSTNAME_FIELD.getPreferredName(), this.workerHostname);
            if (this.syncCursor != null) {
                builder.field(Connector.SYNC_CURSOR_FIELD.getPreferredName(), this.syncCursor);
            }
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorSyncJobId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_sync_job_id] of the connector sync job cannot be null or empty.", validationException);
            }
            if (this.workerHostname == null) {
                validationException = ValidateActions.addValidationError((String)"[worker_hostname] of the connector sync job cannot be null.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorSyncJobId);
            out.writeString(this.workerHostname);
            out.writeGenericValue(this.syncCursor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorSyncJobId, request.connectorSyncJobId) && Objects.equals(this.workerHostname, request.workerHostname) && Objects.equals(this.syncCursor, request.syncCursor);
        }

        public int hashCode() {
            return Objects.hash(this.connectorSyncJobId, this.workerHostname, this.syncCursor);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.WORKER_HOSTNAME_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> parser.map(), Connector.SYNC_CURSOR_FIELD);
        }
    }
}

