/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.secrets.ConnectorSecretsIndexService;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretRequest;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretResponse;

public class TransportPutConnectorSecretAction
extends HandledTransportAction<PutConnectorSecretRequest, PutConnectorSecretResponse> {
    private final ConnectorSecretsIndexService connectorSecretsIndexService;

    @Inject
    public TransportPutConnectorSecretAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/connector/secret/put", transportService, actionFilters, PutConnectorSecretRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorSecretsIndexService = new ConnectorSecretsIndexService(client);
    }

    protected void doExecute(Task task, PutConnectorSecretRequest request, ActionListener<PutConnectorSecretResponse> listener) {
        this.connectorSecretsIndexService.createSecretWithDocId(request, listener);
    }
}

