/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class ConfigurationSelectOption
implements Writeable,
ToXContentObject {
    private final String label;
    private final Object value;
    private static final ParseField LABEL_FIELD = new ParseField("label", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<ConfigurationSelectOption, Void> PARSER = new ConstructingObjectParser("connector_configuration_select_option", true, args -> new Builder().setLabel((String)args[0]).setValue(args[1]).build());

    private ConfigurationSelectOption(String label, Object value) {
        this.label = label;
        this.value = value;
    }

    public ConfigurationSelectOption(StreamInput in) throws IOException {
        this.label = in.readString();
        this.value = in.readGenericValue();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LABEL_FIELD.getPreferredName(), this.label);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(LABEL_FIELD.getPreferredName(), this.label);
        map.put(VALUE_FIELD.getPreferredName(), this.value);
        return map;
    }

    public static ConfigurationSelectOption fromXContent(XContentParser parser) throws IOException {
        return (ConfigurationSelectOption)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.label);
        out.writeGenericValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationSelectOption that = (ConfigurationSelectOption)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.value);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LABEL_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, VALUE_FIELD, ObjectParser.ValueType.VALUE);
    }

    public static class Builder {
        private String label;
        private Object value;

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public ConfigurationSelectOption build() {
            return new ConfigurationSelectOption(this.label, this.value);
        }
    }
}

