/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.JsonIngestPipelineConfig;

public class ConnectorTemplateRegistry
extends IndexTemplateRegistry {
    public static final NodeFeature CONNECTOR_TEMPLATES_FEATURE = new NodeFeature("elastic-connectors.templates");
    static final int REGISTRY_VERSION = 3;
    public static final String CONNECTOR_INDEX_NAME_PATTERN = ".elastic-connectors-v1";
    public static final String CONNECTOR_TEMPLATE_NAME = "elastic-connectors";
    public static final String CONNECTOR_SYNC_JOBS_INDEX_NAME_PATTERN = ".elastic-connectors-sync-jobs-v1";
    public static final String CONNECTOR_SYNC_JOBS_TEMPLATE_NAME = "elastic-connectors-sync-jobs";
    public static final String ACCESS_CONTROL_INDEX_PREFIX = ".search-acl-filter-";
    public static final String ACCESS_CONTROL_INDEX_NAME_PATTERN = ".search-acl-filter-*";
    public static final String ACCESS_CONTROL_TEMPLATE_NAME = "search-acl-filter";
    public static final String ENT_SEARCH_GENERIC_PIPELINE_NAME = "ent-search-generic-ingestion";
    public static final String ENT_SEARCH_GENERIC_PIPELINE_FILE = "generic_ingestion_pipeline";
    public static final String SEARCH_DEFAULT_PIPELINE_NAME = "search-default-ingestion";
    public static final String SEARCH_DEFAULT_PIPELINE_FILE = "search_default_pipeline";
    public static final String ROOT_RESOURCE_PATH = "/entsearch/";
    public static final String ROOT_TEMPLATE_RESOURCE_PATH = "/entsearch/connector/";
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.application.connector.template.version";
    private static final String MAPPINGS_SUFFIX = "-mappings";
    private static final String SETTINGS_SUFFIX = "-settings";
    private static final String JSON_EXTENSION = ".json";
    static final Map<String, ComponentTemplate> COMPONENT_TEMPLATES;
    static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATES;
    private final FeatureService featureService;

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return List.of(new JsonIngestPipelineConfig(ENT_SEARCH_GENERIC_PIPELINE_NAME, "/entsearch/generic_ingestion_pipeline.json", 3, TEMPLATE_VERSION_VARIABLE), new JsonIngestPipelineConfig(SEARCH_DEFAULT_PIPELINE_NAME, "/entsearch/search_default_pipeline.json", 3, TEMPLATE_VERSION_VARIABLE));
    }

    public ConnectorTemplateRegistry(ClusterService clusterService, FeatureService featureService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(Settings.EMPTY, clusterService, threadPool, client, xContentRegistry);
        this.featureService = featureService;
    }

    protected String getOrigin() {
        return "enterprise_search";
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return COMPONENT_TEMPLATES;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return COMPOSABLE_INDEX_TEMPLATES;
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return this.featureService.clusterHasFeature(event.state(), CONNECTOR_TEMPLATES_FEATURE);
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig("elastic-connectors-mappings", "/entsearch/connector/elastic-connectors-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("elastic-connectors-settings", "/entsearch/connector/elastic-connectors-settings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("elastic-connectors-sync-jobs-mappings", "/entsearch/connector/elastic-connectors-sync-jobs-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("elastic-connectors-sync-jobs-settings", "/entsearch/connector/elastic-connectors-settings.json", 3, TEMPLATE_VERSION_VARIABLE))) {
            try {
                XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes());
                try {
                    componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)parser));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATES = Map.copyOf(componentTemplates);
        COMPOSABLE_INDEX_TEMPLATES = ConnectorTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(CONNECTOR_TEMPLATE_NAME, "/entsearch/connector/elastic-connectors.json", 3, TEMPLATE_VERSION_VARIABLE, Map.of("connectors.index_pattern", CONNECTOR_INDEX_NAME_PATTERN)), new IndexTemplateConfig(CONNECTOR_SYNC_JOBS_TEMPLATE_NAME, "/entsearch/connector/elastic-connectors-sync-jobs.json", 3, TEMPLATE_VERSION_VARIABLE, Map.of("connectors-sync-jobs.index_pattern", CONNECTOR_SYNC_JOBS_INDEX_NAME_PATTERN)), new IndexTemplateConfig(ACCESS_CONTROL_TEMPLATE_NAME, "/entsearch/connector/search-acl-filter.json", 3, TEMPLATE_VERSION_VARIABLE, Map.of("access-control.index_pattern", ACCESS_CONTROL_INDEX_NAME_PATTERN))});
    }
}

