/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.util.List;
import org.elasticsearch.server.cli.SystemMemoryInfo;

public abstract class JvmArgumentParsingSystemMemoryInfo
implements SystemMemoryInfo {
    private final List<String> userDefinedJvmOptions;

    public JvmArgumentParsingSystemMemoryInfo(List<String> userDefinedJvmOptions) {
        this.userDefinedJvmOptions = userDefinedJvmOptions;
    }

    protected long getBytesFromSystemProperty(String systemProperty, long defaultValue) {
        return this.userDefinedJvmOptions.stream().filter(option -> option.startsWith("-D" + systemProperty + "=")).map(totalMemoryOverheadBytesOption -> {
            try {
                long bytes = Long.parseLong(totalMemoryOverheadBytesOption.split("=", 2)[1]);
                if (bytes < 0L) {
                    throw new IllegalArgumentException("Negative bytes size specified in [" + totalMemoryOverheadBytesOption + "]");
                }
                return bytes;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse number of bytes from [" + totalMemoryOverheadBytesOption + "]", e);
            }
        }).reduce((previous, current) -> current).orElse(defaultValue);
    }
}

