/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseEnum
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final Class<? extends Enum<?>> enumClass;
    private final boolean ignoreCase;

    public <T extends Enum<?>> ParseEnum(Class<T> enumClass) {
        ParseEnum.checkPreconditions(enumClass);
        this.enumClass = enumClass;
        this.ignoreCase = false;
    }

    public <T extends Enum<?>> ParseEnum(Class<T> enumClass, boolean ignoreCase) {
        ParseEnum.checkPreconditions(enumClass);
        this.enumClass = enumClass;
        this.ignoreCase = ignoreCase;
    }

    public <T extends Enum<?>> ParseEnum(Class<T> enumClass, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(enumClass);
        this.enumClass = enumClass;
        this.ignoreCase = false;
    }

    public <T extends Enum<?>> ParseEnum(Class<T> enumClass, boolean ignoreCase, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(enumClass);
        this.enumClass = enumClass;
        this.ignoreCase = ignoreCase;
    }

    private static void checkPreconditions(Class<?> enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        String inputString = value.toString();
        for (Enum<?> enumConstant : this.enumClass.getEnumConstants()) {
            String constantName = enumConstant.name();
            if (!(this.ignoreCase ? constantName.equalsIgnoreCase(inputString) : constantName.equals(inputString))) continue;
            return enumConstant;
        }
        throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a enum of type %s", value, this.enumClass.getName()), context, this);
    }
}

