/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class ScoreOperator
extends AbstractPageMappingOperator {
    private final BlockFactory blockFactory;
    private final ExpressionScorer scorer;
    private final int scoreBlockPosition;

    public ScoreOperator(BlockFactory blockFactory, ExpressionScorer scorer, int scoreBlockPosition) {
        this.blockFactory = blockFactory;
        this.scorer = scorer;
        this.scoreBlockPosition = scoreBlockPosition;
    }

    @Override
    protected Page process(Page page) {
        assert (page.getBlockCount() >= 2) : "Expected at least 2 blocks, got " + page.getBlockCount();
        assert (page.getBlock(0).asVector() instanceof DocVector) : "Expected a DocVector, got " + page.getBlock(0).asVector();
        assert (page.getBlock(1).asVector() instanceof DoubleVector) : "Expected a DoubleVector, got " + page.getBlock(1).asVector();
        Block[] blocks = new Block[page.getBlockCount()];
        for (int i = 0; i < page.getBlockCount(); ++i) {
            blocks[i] = i == this.scoreBlockPosition ? this.calculateScoresBlock(page) : page.getBlock(i);
        }
        return new Page(blocks);
    }

    private Block calculateScoresBlock(Page page) {
        try (DoubleBlock evalScores = this.scorer.score(page);){
            DoubleBlock doubleBlock;
            block13: {
                DoubleBlock existingScores = (DoubleBlock)page.getBlock(this.scoreBlockPosition);
                try {
                    int rowCount = page.getPositionCount();
                    DoubleVector.FixedBuilder builder = this.blockFactory.newDoubleVectorFixedBuilder(rowCount);
                    for (int i = 0; i < rowCount; ++i) {
                        builder.appendDouble(existingScores.getDouble(i) + evalScores.getDouble(i));
                    }
                    doubleBlock = builder.build().asBlock();
                    if (existingScores == null) break block13;
                }
                catch (Throwable throwable) {
                    if (existingScores != null) {
                        try {
                            existingScores.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                existingScores.close();
            }
            return doubleBlock;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[scorer=" + this.scorer + "]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scorer, () -> super.close()});
    }

    public static interface ExpressionScorer
    extends Releasable {
        public DoubleBlock score(Page var1);

        public static interface Factory {
            public ExpressionScorer get(DriverContext var1);
        }
    }

    public record ScoreOperatorFactory(ExpressionScorer.Factory scorerFactory, int scoreBlockPosition) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ScoreOperator(driverContext.blockFactory(), this.scorerFactory.get(driverContext), this.scoreBlockPosition);
        }

        @Override
        public String describe() {
            return "ScoreOperator[scorer=" + this.scorerFactory + "]";
        }
    }
}

