/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class MvExpandOperator
implements Operator {
    private static final Logger logger = LogManager.getLogger(MvExpandOperator.class);
    private final int channel;
    private final int pageSize;
    private int noops;
    private Page prev;
    private boolean prevCompleted;
    private boolean finished = false;
    private Block expandingBlock;
    private Block expandedBlock;
    private int nextPositionToProcess = 0;
    private int nextMvToProcess = 0;
    private int nextItemOnExpanded = 0;
    private int pagesReceived;
    private int pagesEmitted;
    private long rowsReceived;
    private long rowsEmitted;

    public MvExpandOperator(int channel, int pageSize) {
        this.channel = channel;
        this.pageSize = pageSize;
        assert (pageSize > 0);
    }

    @Override
    public final Page getOutput() {
        Page result = this.getOutputInternal();
        if (result != null) {
            ++this.pagesEmitted;
            this.rowsEmitted += (long)result.getPositionCount();
        }
        return result;
    }

    private Page getOutputInternal() {
        if (this.prev == null) {
            return null;
        }
        if (this.expandedBlock == null) {
            logger.trace("starting {}", new Object[]{this.prev});
            this.expandingBlock = this.prev.getBlock(this.channel);
            this.expandedBlock = this.expandingBlock.expand();
            if (this.expandedBlock == this.expandingBlock) {
                logger.trace("expanded to same");
                ++this.noops;
                Page result = this.prev;
                this.prev = null;
                this.releaseAndClearState();
                return result;
            }
            if (this.prev.getBlockCount() == 1) {
                logger.trace("single block output");
                assert (this.channel == 0);
                Page result = new Page(this.expandedBlock);
                this.expandedBlock = null;
                this.releaseAndClearState();
                return result;
            }
        }
        logger.trace("slicing");
        return this.sliceExpandedIntoPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page sliceExpandedIntoPages() {
        this.prevCompleted = false;
        int[] duplicateFilter = this.nextDuplicateExpandingFilter();
        Releasable[] result = new Block[this.prev.getBlockCount()];
        boolean success = false;
        try {
            int[] expandedMask = new int[duplicateFilter.length];
            for (int i = 0; i < expandedMask.length; ++i) {
                expandedMask[i] = i + this.nextItemOnExpanded;
            }
            this.nextItemOnExpanded += expandedMask.length;
            for (int b = 0; b < result.length; ++b) {
                result[b] = b == this.channel ? this.expandedBlock.filter(expandedMask) : this.prev.getBlock(b).filter(duplicateFilter);
            }
            success = true;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])result);
            }
        }
        if (this.nextItemOnExpanded == this.expandedBlock.getPositionCount()) {
            this.nextItemOnExpanded = 0;
        }
        if (this.prevCompleted) {
            this.releaseAndClearState();
        }
        return new Page((Block[])result);
    }

    private int[] nextDuplicateExpandingFilter() {
        int[] duplicateFilter = new int[Math.min(this.pageSize, this.expandedBlock.getPositionCount() - this.nextPositionToProcess)];
        int n = 0;
        do {
            int count;
            int positions = (count = this.expandingBlock.getValueCount(this.nextPositionToProcess)) == 0 ? 1 : count;
            int toAdd = Math.min(this.pageSize - n, positions - this.nextMvToProcess);
            Arrays.fill(duplicateFilter, n, n + toAdd, this.nextPositionToProcess);
            if ((n += toAdd) == this.pageSize) {
                if (this.nextMvToProcess + toAdd == positions) {
                    this.nextMvToProcess = 0;
                    ++this.nextPositionToProcess;
                    if (this.nextPositionToProcess == this.expandingBlock.getPositionCount()) {
                        this.nextPositionToProcess = 0;
                        this.prevCompleted = true;
                    }
                } else {
                    this.nextMvToProcess += toAdd;
                }
                return duplicateFilter;
            }
            this.nextMvToProcess = 0;
            ++this.nextPositionToProcess;
        } while (this.nextPositionToProcess != this.expandingBlock.getPositionCount());
        this.nextPositionToProcess = 0;
        this.nextMvToProcess = 0;
        this.prevCompleted = true;
        return n < this.pageSize ? Arrays.copyOfRange(duplicateFilter, 0, n) : duplicateFilter;
    }

    private void releaseAndClearState() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.prev != null) {
                this.prev.releaseBlocks();
                this.prev = null;
            }
        }, this.expandedBlock});
        this.expandingBlock = null;
        this.expandedBlock = null;
    }

    @Override
    public final boolean needsInput() {
        return this.prev == null && !this.finished;
    }

    @Override
    public final void addInput(Page page) {
        assert (this.prev == null) : "has pending input page";
        this.prev = page;
        this.expandingBlock = this.prev.getBlock(this.channel);
        ++this.pagesReceived;
        this.rowsReceived += (long)page.getPositionCount();
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && this.prev == null;
    }

    @Override
    public final Status status() {
        return new Status(this.pagesReceived, this.pagesEmitted, this.noops, this.rowsReceived, this.rowsEmitted);
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.prev != null) {
                this.prev.releaseBlocks();
            }
        }, this.expandedBlock});
    }

    public String toString() {
        return "MvExpandOperator[channel=" + this.channel + "]";
    }

    public static final class Status
    implements Operator.Status {
        private final int pagesReceived;
        private final int pagesEmitted;
        private final int noops;
        private final long rowsReceived;
        private final long rowsEmitted;
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "mv_expand", Status::new);

        Status(int pagesReceived, int pagesEmitted, int noops, long rowsReceived, long rowsEmitted) {
            this.pagesReceived = pagesReceived;
            this.pagesEmitted = pagesEmitted;
            this.noops = noops;
            this.rowsReceived = rowsReceived;
            this.rowsEmitted = rowsEmitted;
        }

        Status(StreamInput in) throws IOException {
            this.pagesReceived = in.readVInt();
            this.pagesEmitted = in.readVInt();
            this.noops = in.readVInt();
            if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                this.rowsReceived = in.readVLong();
                this.rowsEmitted = in.readVLong();
            } else {
                this.rowsReceived = 0L;
                this.rowsEmitted = 0L;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesReceived);
            out.writeVInt(this.pagesEmitted);
            out.writeVInt(this.noops);
            if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeVLong(this.rowsReceived);
                out.writeVLong(this.rowsEmitted);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_received", this.pagesReceived);
            builder.field("pages_emitted", this.pagesEmitted);
            builder.field("noops", this.noops);
            builder.field("rows_received", this.rowsReceived);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder.endObject();
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int noops() {
            return this.noops;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.noops == status.noops && this.pagesReceived == status.pagesReceived && this.pagesEmitted == status.pagesEmitted && this.rowsReceived == status.rowsReceived && this.rowsEmitted == status.rowsEmitted;
        }

        public int pagesReceived() {
            return this.pagesReceived;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.noops, this.pagesReceived, this.pagesEmitted, this.rowsReceived, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public record Factory(int channel, int blockSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new MvExpandOperator(this.channel, this.blockSize);
        }

        @Override
        public String describe() {
            return "MvExpandOperator[channel=" + this.channel + "]";
        }
    }
}

