/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class EvalOperator
extends AbstractPageMappingOperator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(EvalOperator.class);
    private final DriverContext ctx;
    private final ExpressionEvaluator evaluator;
    public static final ExpressionEvaluator.Factory CONSTANT_NULL_FACTORY = new ExpressionEvaluator.Factory(){

        @Override
        public ExpressionEvaluator get(final DriverContext driverContext) {
            return new ExpressionEvaluator(){

                @Override
                public Block eval(Page page) {
                    return driverContext.blockFactory().newConstantNullBlock(page.getPositionCount());
                }

                public void close() {
                }

                public String toString() {
                    return EvalOperator.CONSTANT_NULL_NAME;
                }

                @Override
                public long baseRamBytesUsed() {
                    return 0L;
                }
            };
        }

        public String toString() {
            return EvalOperator.CONSTANT_NULL_NAME;
        }
    };
    private static final String CONSTANT_NULL_NAME = "ConstantNull";

    public EvalOperator(DriverContext ctx, ExpressionEvaluator evaluator) {
        this.ctx = ctx;
        this.evaluator = evaluator;
        ctx.breaker().addEstimateBytesAndMaybeBreak(BASE_RAM_BYTES_USED + evaluator.baseRamBytesUsed(), "ESQL");
    }

    @Override
    protected Page process(Page page) {
        Block block = this.evaluator.eval(page);
        return page.appendBlock(block);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[evaluator=" + this.evaluator + "]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.evaluator, () -> this.ctx.breaker().addWithoutBreaking(-BASE_RAM_BYTES_USED - this.evaluator.baseRamBytesUsed()), () -> super.close()});
    }

    public static interface ExpressionEvaluator
    extends Releasable {
        public Block eval(Page var1);

        public long baseRamBytesUsed();

        public static interface Factory {
            public ExpressionEvaluator get(DriverContext var1);

            default public boolean eagerEvalSafeInLazy() {
                return false;
            }
        }
    }

    public record EvalOperatorFactory(ExpressionEvaluator.Factory evaluator) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new EvalOperator(driverContext, this.evaluator.get(driverContext));
        }

        @Override
        public String describe() {
            return "EvalOperator[evaluator=" + this.evaluator + "]";
        }
    }
}

