/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingToIteratorOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.ReleasableIterator;

public class ColumnLoadOperator
extends AbstractPageMappingToIteratorOperator {
    private final Values values;
    private final int positionsOrd;
    static final ByteSizeValue TARGET_BLOCK_SIZE = ByteSizeValue.ofKb((long)10L);

    public ColumnLoadOperator(Values values, int positionsOrd) {
        this.values = values;
        this.positionsOrd = positionsOrd;
    }

    @Override
    protected ReleasableIterator<Page> receive(Page page) {
        return ColumnLoadOperator.appendBlocks(page, this.values.block.lookup((IntBlock)page.getBlock(this.positionsOrd), TARGET_BLOCK_SIZE));
    }

    @Override
    public String toString() {
        return "ColumnLoad[values=" + this.values + ", positions=" + this.positionsOrd + "]";
    }

    public record Values(String name, Block block) {
        @Override
        public String toString() {
            return this.name + ":" + this.block.elementType();
        }
    }

    public record Factory(Values values, int positionsOrd) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ColumnLoadOperator(this.values, this.positionsOrd);
        }

        @Override
        public String describe() {
            return "ColumnLoad[values=" + this.values + ", positions=" + this.positionsOrd + "]";
        }
    }
}

