/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AsyncOperator<Fetched>
implements Operator {
    private volatile SubscribableListener<Void> blockedFuture;
    private final Map<Long, Fetched> buffers = ConcurrentCollections.newConcurrentMap();
    private final FailureCollector failureCollector = new FailureCollector();
    private final DriverContext driverContext;
    private final int maxOutstandingRequests;
    private final LongAdder totalTimeInNanos = new LongAdder();
    private boolean finished = false;
    private volatile boolean closed = false;
    private final LocalCheckpointTracker checkpoint = new LocalCheckpointTracker(-1L, -1L);

    public AsyncOperator(DriverContext driverContext, int maxOutstandingRequests) {
        this.driverContext = driverContext;
        this.maxOutstandingRequests = maxOutstandingRequests;
    }

    @Override
    public boolean needsInput() {
        long outstandingPages = this.checkpoint.getMaxSeqNo() - this.checkpoint.getPersistedCheckpoint();
        return outstandingPages < (long)this.maxOutstandingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page input) {
        if (this.failureCollector.hasFailure()) {
            input.releaseBlocks();
            return;
        }
        long seqNo = this.checkpoint.generateSeqNo();
        this.driverContext.addAsyncAction();
        boolean success = false;
        try {
            ActionListener listener = ActionListener.wrap(output -> {
                this.buffers.put(seqNo, output);
                this.onSeqNoCompleted(seqNo);
            }, e -> {
                AsyncOperator.releasePageOnAnyThread(input);
                this.failureCollector.unwrapAndCollect((Exception)e);
                this.onSeqNoCompleted(seqNo);
            });
            long startNanos = System.nanoTime();
            this.performAsync(input, ActionListener.runAfter((ActionListener)listener, () -> {
                this.driverContext.removeAsyncAction();
                this.totalTimeInNanos.add(System.nanoTime() - startNanos);
            }));
            success = true;
        }
        finally {
            if (!success) {
                this.driverContext.removeAsyncAction();
            }
        }
    }

    protected static void releasePageOnAnyThread(Page page) {
        page.allowPassingToDifferentDriver();
        page.releaseBlocks();
    }

    protected abstract void releaseFetchedOnAnyThread(Fetched var1);

    protected abstract void performAsync(Page var1, ActionListener<Fetched> var2);

    protected abstract void doClose();

    private void onSeqNoCompleted(long seqNo) {
        this.checkpoint.markSeqNoAsProcessed(seqNo);
        if (this.checkpoint.getPersistedCheckpoint() < this.checkpoint.getProcessedCheckpoint()) {
            this.notifyIfBlocked();
        }
        if (this.closed || this.failureCollector.hasFailure()) {
            this.discardResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfBlocked() {
        if (this.blockedFuture != null) {
            SubscribableListener<Void> future;
            AsyncOperator asyncOperator = this;
            synchronized (asyncOperator) {
                future = this.blockedFuture;
                this.blockedFuture = null;
            }
            if (future != null) {
                future.onResponse(null);
            }
        }
    }

    private void checkFailure() {
        Exception e = this.failureCollector.getFailure();
        if (e != null) {
            this.discardResults();
            throw ExceptionsHelper.convertToRuntime((Exception)e);
        }
    }

    private void discardResults() {
        long nextCheckpoint;
        while ((nextCheckpoint = this.checkpoint.getPersistedCheckpoint() + 1L) <= this.checkpoint.getProcessedCheckpoint()) {
            Fetched result = this.buffers.remove(nextCheckpoint);
            this.checkpoint.markSeqNoAsPersisted(nextCheckpoint);
            if (result == null) continue;
            this.releaseFetchedOnAnyThread(result);
        }
    }

    @Override
    public final void close() {
        this.finish();
        this.closed = true;
        this.discardResults();
        this.doClose();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        if (this.finished && this.checkpoint.getPersistedCheckpoint() == this.checkpoint.getMaxSeqNo()) {
            this.checkFailure();
            return true;
        }
        return false;
    }

    public final Fetched fetchFromBuffer() {
        this.checkFailure();
        long persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
        if (persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
            Fetched result = this.buffers.remove(++persistedCheckpoint);
            this.checkpoint.markSeqNoAsPersisted(persistedCheckpoint);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsBlockedResult isBlocked() {
        if (this.finished) {
            return Operator.NOT_BLOCKED;
        }
        long persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
        if (persistedCheckpoint == this.checkpoint.getMaxSeqNo() || persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
            return Operator.NOT_BLOCKED;
        }
        AsyncOperator asyncOperator = this;
        synchronized (asyncOperator) {
            persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
            if (persistedCheckpoint == this.checkpoint.getMaxSeqNo() || persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
                return Operator.NOT_BLOCKED;
            }
            if (this.blockedFuture == null) {
                this.blockedFuture = new SubscribableListener();
            }
            return new IsBlockedResult(this.blockedFuture, this.getClass().getSimpleName());
        }
    }

    @Override
    public final Operator.Status status() {
        return this.status(Math.max(0L, this.checkpoint.getMaxSeqNo()), Math.max(0L, this.checkpoint.getProcessedCheckpoint()), TimeValue.timeValueNanos((long)this.totalTimeInNanos.sum()).millis());
    }

    protected Operator.Status status(long receivedPages, long completedPages, long totalTimeInMillis) {
        return new Status(receivedPages, completedPages, totalTimeInMillis);
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "async_operator", Status::new);
        final long receivedPages;
        final long completedPages;
        final long totalTimeInMillis;

        protected Status(long receivedPages, long completedPages, long totalTimeInMillis) {
            this.receivedPages = receivedPages;
            this.completedPages = completedPages;
            this.totalTimeInMillis = totalTimeInMillis;
        }

        protected Status(StreamInput in) throws IOException {
            this.receivedPages = in.readVLong();
            this.completedPages = in.readVLong();
            this.totalTimeInMillis = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.receivedPages);
            out.writeVLong(this.completedPages);
            out.writeVLong(this.totalTimeInMillis);
        }

        public long receivedPages() {
            return this.receivedPages;
        }

        public long completedPages() {
            return this.completedPages;
        }

        public long totalTimeInMillis() {
            return this.totalTimeInMillis;
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        protected final XContentBuilder innerToXContent(XContentBuilder builder) throws IOException {
            builder.field("received_pages", this.receivedPages);
            builder.field("completed_pages", this.completedPages);
            builder.field("total_time_in_millis", this.totalTimeInMillis);
            if (this.totalTimeInMillis >= 0L) {
                builder.field("total_time", (Object)TimeValue.timeValueMillis((long)this.totalTimeInMillis));
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.receivedPages == status.receivedPages && this.completedPages == status.completedPages && this.totalTimeInMillis == status.totalTimeInMillis;
        }

        public int hashCode() {
            return Objects.hash(this.receivedPages, this.completedPages, this.totalTimeInMillis);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_14_0;
        }
    }
}

