/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntLookup;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

public final class IntBigArrayVector
extends AbstractVector
implements IntVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final IntArray values;
    private Integer min;
    private Integer max;

    public IntBigArrayVector(IntArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IntBigArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        IntArray values = blockFactory.bigArrays().newIntArray((long)positions, false);
        boolean success = false;
        try {
            values.fillWith(in);
            IntBigArrayVector vector = new IntBigArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(vector.ramBytesUsed() - RamUsageEstimator.sizeOf((Accountable)values));
            success = true;
            IntBigArrayVector intBigArrayVector = vector;
            return intBigArrayVector;
        }
        finally {
            if (!success) {
                values.close();
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        this.values.writeTo(out);
    }

    @Override
    public IntBlock asBlock() {
        return new IntVectorBlock(this);
    }

    @Override
    public int getInt(int position) {
        return this.values.get((long)position);
    }

    @Override
    public int min() {
        if (this.min == null) {
            int v = this.values.get(0L);
            for (int i = 1; i < this.getPositionCount(); ++i) {
                v = Math.min(v, this.values.get((long)i));
            }
            this.min = v;
        }
        return this.min;
    }

    @Override
    public int max() {
        if (this.max == null) {
            int v = this.values.get(0L);
            for (int i = 1; i < this.getPositionCount(); ++i) {
                v = Math.max(v, this.values.get((long)i));
            }
            this.max = v;
        }
        return this.max;
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return 0L + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public IntVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        IntArray filtered = blockFactory.bigArrays().newIntArray((long)positions.length);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new IntBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public IntBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new IntVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new IntVectorBlock(this);
            }
            return (IntBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (IntBlock.Builder builder = this.blockFactory().newIntBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendInt(this.getInt(p));
                    continue;
                }
                builder.appendNull();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public ReleasableIterator<IntBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new IntLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public void closeInternal() {
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntVector) {
            IntVector that = (IntVector)obj;
            return IntVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

