/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DoubleBlock
extends Block {
    public double getDouble(int var1);

    @Override
    public DoubleVector asVector();

    @Override
    public DoubleBlock filter(int ... var1);

    @Override
    public DoubleBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends DoubleBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public DoubleBlock expand();

    public static DoubleBlock readFrom(BlockStreamInput in) throws IOException {
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> DoubleBlock.readValues(in);
            case 1 -> DoubleVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
            case 2 -> DoubleArrayBlock.readArrayBlock(in.blockFactory(), in);
            case 3 -> DoubleBigArrayBlock.readArrayBlock(in.blockFactory(), in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid block serialization type " + serializationType));
                }
                throw new IllegalStateException("invalid serialization type " + serializationType);
            }
        };
    }

    private static DoubleBlock readValues(BlockStreamInput in) throws IOException {
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newDoubleBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendDouble(in.readDouble());
                }
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    default public void writeTo(StreamOutput out) throws IOException {
        DoubleBlock doubleBlock;
        DoubleVector vector = this.asVector();
        TransportVersion version = out.getTransportVersion();
        if (vector != null) {
            out.writeByte((byte)1);
            vector.writeTo(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (doubleBlock = this) instanceof DoubleArrayBlock) {
            DoubleArrayBlock b = (DoubleArrayBlock)doubleBlock;
            out.writeByte((byte)2);
            b.writeArrayBlock(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (doubleBlock = this) instanceof DoubleBigArrayBlock) {
            DoubleBigArrayBlock b = (DoubleBigArrayBlock)doubleBlock;
            out.writeByte((byte)3);
            b.writeArrayBlock(out);
        } else {
            out.writeByte((byte)0);
            DoubleBlock.writeValues(this, out);
        }
    }

    private static void writeValues(DoubleBlock block, StreamOutput out) throws IOException {
        int positions = block.getPositionCount();
        out.writeVInt(positions);
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            int valueCount = block.getValueCount(pos);
            out.writeVInt(valueCount);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                out.writeDouble(block.getDouble(block.getFirstValueIndex(pos) + valueIndex));
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(DoubleBlock block1, DoubleBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getDouble(b1ValueIdx + valueIndex) == block2.getDouble(b2ValueIdx + valueIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(DoubleBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                long element = Double.doubleToLongBits(block.getDouble(firstValueIdx + valueIndex));
                result = 31 * result + (int)(element ^ element >>> 32);
            }
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Block.Builder,
    BlockLoader.DoubleBuilder {
        public Builder appendDouble(double var1);

        public Builder copyFrom(DoubleBlock var1, int var2, int var3);

        public Builder copyFrom(DoubleBlock var1, int var2);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public DoubleBlock build();
    }
}

