/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BlockUtils {
    public static final Block[] NO_BLOCKS = new Block[0];

    private BlockUtils() {
    }

    public static Block[] fromArrayRow(BlockFactory blockFactory, Object ... row) {
        return BlockUtils.fromListRow(blockFactory, Arrays.asList(row));
    }

    public static Block[] fromListRow(BlockFactory blockFactory, List<Object> row) {
        return BlockUtils.fromListRow(blockFactory, row, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block[] fromListRow(BlockFactory blockFactory, List<Object> row, int blockSize) {
        if (row.isEmpty()) {
            return NO_BLOCKS;
        }
        int size = row.size();
        Releasable[] blocks = new Block[size];
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                Object object = row.get(i);
                if (object instanceof List) {
                    List listVal = (List)object;
                    try (BuilderWrapper wrapper = BlockUtils.wrapperFor(blockFactory, ElementType.fromJava(listVal.get(0).getClass()), blockSize);){
                        wrapper.accept(listVal);
                        Random random = Randomness.get();
                        if (BlockUtils.isDeduplicated(listVal) && random.nextBoolean()) {
                            if (BlockUtils.isAscending(listVal) && random.nextBoolean()) {
                                wrapper.builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
                            } else {
                                wrapper.builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_UNORDERD);
                            }
                        } else if (BlockUtils.isAscending(listVal) && random.nextBoolean()) {
                            wrapper.builder.mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
                        }
                        blocks[i] = wrapper.builder.build();
                        continue;
                    }
                }
                blocks[i] = BlockUtils.constantBlock(blockFactory, object, blockSize);
            }
            success = true;
            Releasable[] releasableArray = blocks;
            return releasableArray;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    private static boolean isAscending(List<?> values) {
        Comparable prev = null;
        for (Object o : values) {
            Comparable val = (Comparable)o;
            if (prev == null) {
                prev = val;
                continue;
            }
            if (prev.compareTo(val) > 0) {
                return false;
            }
            prev = val;
        }
        return true;
    }

    private static boolean isDeduplicated(List<?> values) {
        return new HashSet(values).size() == values.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block[] fromList(BlockFactory blockFactory, List<List<Object>> list) {
        int size = list.size();
        if (size == 0) {
            return NO_BLOCKS;
        }
        if (size == 1) {
            return BlockUtils.fromListRow(blockFactory, list.get(0));
        }
        Releasable[] wrappers = new BuilderWrapper[list.get(0).size()];
        try {
            Releasable[] releasableArray;
            for (int i = 0; i < wrappers.length; ++i) {
                wrappers[i] = BlockUtils.wrapperFor(blockFactory, ElementType.fromJava(BlockUtils.type(list, i)), size);
            }
            for (List<Object> values : list) {
                int vSize = values.size();
                for (int j = 0; j < vSize; ++j) {
                    wrappers[j].append.accept(values.get(j));
                }
            }
            Releasable[] blocks = new Block[wrappers.length];
            try {
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = wrappers[i].builder.build();
                }
                releasableArray = blocks;
            }
            catch (Throwable throwable) {
                if (blocks[blocks.length - 1] == null) {
                    Releasables.closeExpectNoException((Releasable[])blocks);
                }
                throw throwable;
            }
            if (blocks[blocks.length - 1] == null) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
            return releasableArray;
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])wrappers);
        }
    }

    public static Block deepCopyOf(Block block, BlockFactory blockFactory) {
        try (Block.Builder builder = block.elementType().newBlockBuilder(block.getPositionCount(), blockFactory);){
            builder.copyFrom(block, 0, block.getPositionCount());
            builder.mvOrdering(block.mvOrdering());
            Block block2 = builder.build();
            return block2;
        }
    }

    private static Class<?> type(List<List<Object>> list, int i) {
        int p = 0;
        while (p < list.size()) {
            Object v;
            if ((v = list.get(p++).get(i)) == null) continue;
            if (v instanceof List) {
                List l = (List)v;
                if (l.isEmpty()) continue;
                return l.get(0).getClass();
            }
            return v.getClass();
        }
        return null;
    }

    public static BuilderWrapper wrapperFor(BlockFactory blockFactory, ElementType type, int size) {
        Block.Builder b = type.newBlockBuilder(size, blockFactory);
        return new BuilderWrapper(b, o -> BlockUtils.appendValue(b, o, type));
    }

    public static void appendValue(Block.Builder builder, Object val, ElementType type) {
        if (val == null) {
            builder.appendNull();
            return;
        }
        switch (type) {
            case LONG: {
                ((LongBlock.Builder)builder).appendLong((Long)val);
                break;
            }
            case INT: {
                ((IntBlock.Builder)builder).appendInt((Integer)val);
                break;
            }
            case BYTES_REF: {
                ((BytesRefBlock.Builder)builder).appendBytesRef(BytesRefs.toBytesRef((Object)val));
                break;
            }
            case FLOAT: {
                ((FloatBlock.Builder)builder).appendFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                ((DoubleBlock.Builder)builder).appendDouble((Double)val);
                break;
            }
            case BOOLEAN: {
                ((BooleanBlock.Builder)builder).appendBoolean((Boolean)val);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported element type [" + type + "]");
            }
        }
    }

    public static Block constantBlock(BlockFactory blockFactory, Object val, int size) {
        if (val == null) {
            return blockFactory.newConstantNullBlock(size);
        }
        if (val instanceof Collection) {
            Collection collection = (Collection)val;
            if (collection.isEmpty()) {
                return BlockUtils.constantBlock(blockFactory, ElementType.NULL, val, size);
            }
            Object colVal = collection.iterator().next();
            return BlockUtils.constantBlock(blockFactory, ElementType.fromJava(colVal.getClass()), colVal, size);
        }
        return BlockUtils.constantBlock(blockFactory, ElementType.fromJava(val.getClass()), val, size);
    }

    private static Block constantBlock(BlockFactory blockFactory, ElementType type, Object val, int size) {
        return switch (type) {
            case ElementType.NULL -> blockFactory.newConstantNullBlock(size);
            case ElementType.LONG -> blockFactory.newConstantLongBlockWith((Long)val, size);
            case ElementType.INT -> blockFactory.newConstantIntBlockWith((Integer)val, size);
            case ElementType.BYTES_REF -> blockFactory.newConstantBytesRefBlockWith(BytesRefs.toBytesRef((Object)val), size);
            case ElementType.DOUBLE -> blockFactory.newConstantDoubleBlockWith((Double)val, size);
            case ElementType.BOOLEAN -> blockFactory.newConstantBooleanBlockWith((Boolean)val, size);
            case ElementType.AGGREGATE_METRIC_DOUBLE -> blockFactory.newConstantAggregateMetricDoubleBlock((AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral)val, size);
            case ElementType.FLOAT -> blockFactory.newConstantFloatBlockWith(((Float)val).floatValue(), size);
            default -> throw new UnsupportedOperationException("unsupported element type [" + type + "]");
        };
    }

    public static Object toJavaObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int count = block.getValueCount(position);
        int start = block.getFirstValueIndex(position);
        if (count == 1) {
            return BlockUtils.valueAtOffset(block, start);
        }
        int end = start + count;
        ArrayList<Object> result = new ArrayList<Object>(count);
        for (int i = start; i < end; ++i) {
            result.add(BlockUtils.valueAtOffset(block, i));
        }
        return result;
    }

    private static Object valueAtOffset(Block block, int offset) {
        return switch (block.elementType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.BOOLEAN -> ((BooleanBlock)block).getBoolean(offset);
            case ElementType.BYTES_REF -> BytesRef.deepCopyOf((BytesRef)((BytesRefBlock)block).getBytesRef(offset, new BytesRef()));
            case ElementType.DOUBLE -> ((DoubleBlock)block).getDouble(offset);
            case ElementType.FLOAT -> Float.valueOf(((FloatBlock)block).getFloat(offset));
            case ElementType.INT -> ((IntBlock)block).getInt(offset);
            case ElementType.LONG -> ((LongBlock)block).getLong(offset);
            case ElementType.NULL -> null;
            case ElementType.DOC -> {
                DocVector v = ((DocBlock)block).asVector();
                yield new Doc(v.shards().getInt(offset), v.segments().getInt(offset), v.docs().getInt(offset));
            }
            case ElementType.COMPOSITE -> throw new IllegalArgumentException("can't read values from composite blocks");
            case ElementType.AGGREGATE_METRIC_DOUBLE -> {
                AggregateMetricDoubleBlock aggBlock = (AggregateMetricDoubleBlock)block;
                yield new AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral(aggBlock.minBlock().getDouble(offset), aggBlock.maxBlock().getDouble(offset), aggBlock.sumBlock().getDouble(offset), aggBlock.countBlock().getInt(offset));
            }
            case ElementType.UNKNOWN -> throw new IllegalArgumentException("can't read values from [" + block + "]");
        };
    }

    public record BuilderWrapper(Block.Builder builder, Consumer<Object> append) implements Releasable
    {
        public BuilderWrapper(Block.Builder builder, Consumer<Object> append) {
            this.builder = builder;
            this.append = o -> {
                if (o == null) {
                    builder.appendNull();
                    return;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    builder.beginPositionEntry();
                    for (Object v : l) {
                        append.accept(v);
                    }
                    builder.endPositionEntry();
                    return;
                }
                append.accept(o);
            };
        }

        public void accept(Object object) {
            this.append.accept(object);
        }

        public void close() {
            this.builder.close();
        }
    }

    public record Doc(int shard, int segment, int doc) {
    }
}

