/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.sort.BytesRefBucketedSort;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.topn.DefaultUnsortableTopNEncoder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

class SampleIntAggregator {
    private static final DefaultUnsortableTopNEncoder ENCODER = new DefaultUnsortableTopNEncoder();

    SampleIntAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays, int limit) {
        return new SingleState(bigArrays, limit);
    }

    public static void combine(SingleState state, int value) {
        state.add(value);
    }

    public static void combineIntermediate(SingleState state, BytesRefBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        BytesRef scratch = new BytesRef();
        for (int i = start; i < end; ++i) {
            state.internalState.sort.collect(values.getBytesRef(i, scratch), 0);
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return SampleIntAggregator.stripWeights(driverContext, state.toBlock(driverContext.blockFactory()));
    }

    public static GroupingState initGrouping(BigArrays bigArrays, int limit) {
        return new GroupingState(bigArrays, limit);
    }

    public static void combine(GroupingState state, int groupId, int value) {
        state.add(groupId, value);
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRefBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        BytesRef scratch = new BytesRef();
        for (int i = start; i < end; ++i) {
            state.sort.collect(values.getBytesRef(i, scratch), groupId);
        }
    }

    public static void combineStates(GroupingState current, int groupId, GroupingState state, int statePosition) {
        current.merge(groupId, state, statePosition);
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return SampleIntAggregator.stripWeights(driverContext, state.toBlock(driverContext.blockFactory(), selected));
    }

    private static Block stripWeights(DriverContext driverContext, Block block) {
        if (block.areAllValuesNull()) {
            return block;
        }
        try (BytesRefBlock bytesRefBlock = (BytesRefBlock)block;){
            IntBlock intBlock;
            block17: {
                IntBlock.Builder intBlock2 = driverContext.blockFactory().newIntBlockBuilder(bytesRefBlock.getPositionCount());
                try {
                    BytesRef scratch = new BytesRef();
                    for (int position = 0; position < block.getPositionCount(); ++position) {
                        if (bytesRefBlock.isNull(position)) {
                            intBlock2.appendNull();
                            continue;
                        }
                        int valueCount = bytesRefBlock.getValueCount(position);
                        if (valueCount > 1) {
                            intBlock2.beginPositionEntry();
                        }
                        int start = bytesRefBlock.getFirstValueIndex(position);
                        int end = start + valueCount;
                        for (int i = start; i < end; ++i) {
                            BytesRef value = bytesRefBlock.getBytesRef(i, scratch).clone();
                            ENCODER.decodeLong(value);
                            intBlock2.appendInt(ENCODER.decodeInt(value));
                        }
                        if (valueCount <= 1) continue;
                        intBlock2.endPositionEntry();
                    }
                    intBlock = intBlock2.build();
                    if (intBlock2 == null) break block17;
                }
                catch (Throwable throwable) {
                    if (intBlock2 != null) {
                        try {
                            intBlock2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                intBlock2.close();
            }
            return intBlock;
        }
    }

    public static class SingleState
    implements AggregatorState {
        private final GroupingState internalState;

        private SingleState(BigArrays bigArrays, int limit) {
            this.internalState = new GroupingState(bigArrays, limit);
        }

        public void add(int value) {
            this.internalState.add(0, value);
        }

        public void merge(GroupingState other) {
            this.internalState.merge(0, other, 0);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            try (IntVector intValues = blockFactory.newConstantIntVector(0, 1);){
                Block block = this.internalState.toBlock(blockFactory, intValues);
                return block;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.internalState);
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BytesRefBucketedSort sort;
        private final BreakingBytesRefBuilder bytesRefBuilder;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GroupingState(BigArrays bigArrays, int limit) {
            CircuitBreaker breaker = bigArrays.breakerService().getBreaker("request");
            this.sort = new BytesRefBucketedSort(breaker, "sample", bigArrays, SortOrder.ASC, limit);
            boolean success = false;
            try {
                this.bytesRefBuilder = new BreakingBytesRefBuilder(breaker, "sample");
                success = true;
            }
            finally {
                if (!success) {
                    Releasables.closeExpectNoException((Releasable)this.sort);
                }
            }
        }

        public void add(int groupId, int value) {
            ENCODER.encodeLong(Randomness.get().nextLong(), this.bytesRefBuilder);
            ENCODER.encodeInt(value, this.bytesRefBuilder);
            this.sort.collect(this.bytesRefBuilder.bytesRefView(), groupId);
            this.bytesRefBuilder.clear();
        }

        public void merge(int groupId, GroupingState other, int otherGroupId) {
            this.sort.merge(groupId, other.sort, otherGroupId);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            return this.sort.toBlock(blockFactory, selected);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.sort, this.bytesRefBuilder});
        }
    }
}

