/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleBytesRefAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleBytesRefAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sample", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final SampleBytesRefAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;

    public SampleBytesRefAggregatorFunction(DriverContext driverContext, List<Integer> channels, SampleBytesRefAggregator.SingleState state, int limit) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
    }

    public static SampleBytesRefAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit) {
        return new SampleBytesRefAggregatorFunction(driverContext, channels, SampleBytesRefAggregator.initSingle(driverContext.bigArrays(), limit), limit);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            BytesRefBlock block = (BytesRefBlock)page.getBlock(this.channels.get(0));
            BytesRefVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        BytesRefBlock block = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(BytesRefVector vector) {
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            SampleBytesRefAggregator.combine(this.state, vector.getBytesRef(i, scratch));
        }
    }

    private void addRawVector(BytesRefVector vector, BooleanVector mask) {
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            SampleBytesRefAggregator.combine(this.state, vector.getBytesRef(i, scratch));
        }
    }

    private void addRawBlock(BytesRefBlock block) {
        BytesRef scratch = new BytesRef();
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SampleBytesRefAggregator.combine(this.state, block.getBytesRef(i, scratch));
            }
        }
    }

    private void addRawBlock(BytesRefBlock block, BooleanVector mask) {
        BytesRef scratch = new BytesRef();
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SampleBytesRefAggregator.combine(this.state, block.getBytesRef(i, scratch));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SampleBytesRefAggregatorFunction.intermediateStateDesc().size());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        assert (sample.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        SampleBytesRefAggregator.combineIntermediate(this.state, sample);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SampleBytesRefAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

