/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongArrayState;
import org.elasticsearch.compute.aggregation.MaxLongAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxLongGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.LONG), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final LongArrayState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public MaxLongGroupingAggregatorFunction(List<Integer> channels, LongArrayState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static MaxLongGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new MaxLongGroupingAggregatorFunction(channels, new LongArrayState(driverContext.bigArrays(), MaxLongAggregator.init()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock valuesBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    MaxLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    MaxLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                MaxLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                MaxLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), values.getLong(v)));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), values.getLong(groupPosition + positionOffset)));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), values.getLong(v)));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), values.getLong(groupPosition + positionOffset)));
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        LongVector max = ((LongBlock)maxUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (max.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (!seen.getBoolean(groupPosition + positionOffset)) continue;
            this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), max.getLong(groupPosition + positionOffset)));
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + this.getClass() + "; got " + input.getClass());
        }
        LongArrayState inState = ((MaxLongGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        if (inState.hasValue(position)) {
            this.state.set(groupId, MaxLongAggregator.combine(this.state.getOrDefault(groupId), inState.get(position)));
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = this.state.toValuesBlock(selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

