/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.reindex.ReindexMetrics;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.reindex.remote.RemoteScrollableHitSource;
import org.elasticsearch.script.CtxMap;
import org.elasticsearch.script.Metadata;
import org.elasticsearch.script.ReindexMetadata;
import org.elasticsearch.script.ReindexScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class Reindexer {
    private static final Logger logger = LogManager.getLogger(Reindexer.class);
    private final ClusterService clusterService;
    private final Client client;
    private final ThreadPool threadPool;
    private final ScriptService scriptService;
    private final ReindexSslConfig reindexSslConfig;
    private final ReindexMetrics reindexMetrics;

    Reindexer(ClusterService clusterService, Client client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig reindexSslConfig, @Nullable ReindexMetrics reindexMetrics) {
        this.clusterService = clusterService;
        this.client = client;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.reindexSslConfig = reindexSslConfig;
        this.reindexMetrics = reindexMetrics;
    }

    public void initTask(BulkByScrollTask task, ReindexRequest request, ActionListener<Void> listener) {
        BulkByScrollParallelizationHelper.initTaskState(task, request, this.client, listener);
    }

    public void execute(BulkByScrollTask task, ReindexRequest request, Client bulkClient, ActionListener<BulkByScrollResponse> listener) {
        long startTime = System.nanoTime();
        BulkByScrollParallelizationHelper.executeSlicedAction(task, request, (ActionType<BulkByScrollResponse>)ReindexAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)task);
            ParentTaskAssigningClient assigningBulkClient = new ParentTaskAssigningClient(bulkClient, this.clusterService.localNode(), (Task)task);
            AsyncIndexBySearchAction searchAction = new AsyncIndexBySearchAction(task, logger, assigningClient, assigningBulkClient, this.threadPool, this.scriptService, this.clusterService.state(), this.reindexSslConfig, request, (ActionListener<BulkByScrollResponse>)ActionListener.runAfter((ActionListener)listener, () -> {
                long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
                if (this.reindexMetrics != null) {
                    this.reindexMetrics.recordTookTime(elapsedTime);
                }
            }));
            searchAction.start();
        });
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, ReindexSslConfig sslConfig, long taskId, List<Thread> threadCollector) {
        Header[] clientHeaders = new Header[remoteInfo.getHeaders().size()];
        int i = 0;
        for (Map.Entry header : remoteInfo.getHeaders().entrySet()) {
            clientHeaders[i++] = new BasicHeader((String)header.getKey(), (String)header.getValue());
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(remoteInfo.getHost(), remoteInfo.getPort(), remoteInfo.getScheme())}).setDefaultHeaders(clientHeaders).setRequestConfigCallback(c -> {
            c.setConnectTimeout(Math.toIntExact(remoteInfo.getConnectTimeout().millis()));
            c.setSocketTimeout(Math.toIntExact(remoteInfo.getSocketTimeout().millis()));
            return c;
        }).setHttpClientConfigCallback(c -> {
            if (remoteInfo.getUsername() != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(remoteInfo.getUsername(), remoteInfo.getPassword().toString());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
                c.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            AtomicInteger threads = new AtomicInteger();
            c.setThreadFactory(r -> {
                String name = "es-client-" + taskId + "-" + threads.getAndIncrement();
                Thread t = new Thread(r, name);
                threadCollector.add(t);
                return t;
            });
            c.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            c.setSSLStrategy((SchemeIOSessionStrategy)sslConfig.getStrategy());
            return c;
        });
        if (Strings.hasLength((String)remoteInfo.getPathPrefix()) && !"/".equals(remoteInfo.getPathPrefix())) {
            builder.setPathPrefix(remoteInfo.getPathPrefix());
        }
        return builder.build();
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<ReindexRequest, TransportReindexAction> {
        private final IdFieldMapper destinationIndexIdMapper;
        private List<Thread> createdThreads = Collections.emptyList();

        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient searchClient, ParentTaskAssigningClient bulkClient, ThreadPool threadPool, ScriptService scriptService, ClusterState state, ReindexSslConfig sslConfig, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
            super(task, request.getDestination().versionType() != VersionType.INTERNAL, false, logger, searchClient, bulkClient, threadPool, request, listener, scriptService, sslConfig);
            this.destinationIndexIdMapper = this.destinationIndexMode(state).idFieldMapperWithoutFieldData();
        }

        private IndexMode destinationIndexMode(ClusterState state) {
            IndexMetadata destMeta = state.metadata().index(((ReindexRequest)this.mainRequest).getDestination().index());
            if (destMeta != null) {
                return (IndexMode)IndexSettings.MODE.get(destMeta.getSettings());
            }
            String template = MetadataIndexTemplateService.findV2Template((org.elasticsearch.cluster.metadata.Metadata)state.metadata(), (String)((ReindexRequest)this.mainRequest).getDestination().index(), (boolean)false);
            if (template == null) {
                return IndexMode.STANDARD;
            }
            Settings settings = MetadataIndexTemplateService.resolveSettings((org.elasticsearch.cluster.metadata.Metadata)state.metadata(), (String)template);
            String indexMode = settings.get(IndexSettings.MODE.getKey());
            return indexMode == null ? IndexMode.STANDARD : IndexMode.fromString((String)indexMode);
        }

        @Override
        protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy, SearchRequest searchRequest) {
            if (((ReindexRequest)this.mainRequest).getRemoteInfo() != null) {
                RemoteInfo remoteInfo = ((ReindexRequest)this.mainRequest).getRemoteInfo();
                this.createdThreads = Collections.synchronizedList(new ArrayList());
                assert (this.sslConfig != null) : "Reindex ssl config must be set";
                RestClient restClient = Reindexer.buildRestClient(remoteInfo, this.sslConfig, this.task.getId(), this.createdThreads);
                return new RemoteScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkerBulkByScrollTaskState)this.worker).countSearchRetry(), this::onScrollResponse, this::finishHim, restClient, remoteInfo, searchRequest);
            }
            return super.buildScrollableResultSource(backoffPolicy, searchRequest);
        }

        @Override
        protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
            super.finishHim(failure, indexingFailures, searchFailures, timedOut);
            for (Thread thread : this.createdThreads) {
                if (!thread.isAlive()) continue;
                assert (false) : "Failed to properly stop client thread [" + thread.getName() + "]";
                this.logger.error("Failed to properly stop client thread [{}]", (Object)thread.getName());
            }
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((ReindexRequest)this.mainRequest).getScript();
            if (script != null) {
                assert (this.scriptService != null) : "Script service must be set";
                return new ReindexScriptApplier(this.worker, this.scriptService, script, script.getParams(), () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index;
            block19: {
                index = new IndexRequest();
                index.index(((ReindexRequest)this.mainRequest).getDestination().index());
                index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
                if (index.versionType() == VersionType.INTERNAL) {
                    assert (doc.getVersion() == -1L) : "fetched version when we didn't have to";
                    index.version(((ReindexRequest)this.mainRequest).getDestination().version());
                } else {
                    index.version(doc.getVersion());
                }
                index.id(this.destinationIndexIdMapper.reindexId(doc.getId()));
                XContentType sourceXContentType = doc.getXContentType();
                XContentType mainRequestXContentType = ((ReindexRequest)this.mainRequest).getDestination().getContentType();
                if (mainRequestXContentType != null && doc.getXContentType() != mainRequestXContentType) {
                    try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)doc.getSource(), (XContentType)sourceXContentType);
                         XContentBuilder builder = XContentBuilder.builder((XContent)mainRequestXContentType.xContent());){
                        parser.nextToken();
                        builder.copyCurrentStructure(parser);
                        index.source(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
                        break block19;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to convert hit from " + sourceXContentType + " to " + mainRequestXContentType, e);
                    }
                }
                index.source(doc.getSource(), doc.getXContentType());
            }
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.setPipeline(((ReindexRequest)this.mainRequest).getDestination().getPipeline());
            if (((ReindexRequest)this.mainRequest).getDestination().opType() == DocWriteRequest.OpType.CREATE) {
                index.opType(((ReindexRequest)this.mainRequest).getDestination().opType());
            }
            return AsyncIndexBySearchAction.wrap(index);
        }

        @Override
        protected void copyRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, String routing) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(request, routing);
                return;
            }
            if (routingSpec.startsWith("=")) {
                super.copyRouting(request, ((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(request, routing);
                    break;
                }
                case "discard": {
                    super.copyRouting(request, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        static class ReindexScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier<ReindexMetadata> {
            private ReindexScript.Factory reindex;

            ReindexScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params, LongSupplier nowInMillisSupplier) {
                super(taskWorker, scriptService, script, params, nowInMillisSupplier);
            }

            @Override
            protected CtxMap<ReindexMetadata> execute(ScrollableHitSource.Hit doc, Map<String, Object> source) {
                if (this.reindex == null) {
                    this.reindex = (ReindexScript.Factory)this.scriptService.compile(this.script, ReindexScript.CONTEXT);
                }
                CtxMap ctxMap = new CtxMap(source, (Metadata)new ReindexMetadata(doc.getIndex(), doc.getId(), Long.valueOf(doc.getVersion()), doc.getRouting(), "index", this.nowInMillisSupplier.getAsLong()));
                this.reindex.newInstance(this.params, ctxMap).execute();
                return ctxMap;
            }

            @Override
            protected void updateRequest(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, ReindexMetadata metadata) {
                if (metadata.indexChanged()) {
                    request.setIndex(metadata.getIndex());
                }
                if (metadata.idChanged()) {
                    request.setId(metadata.getId());
                }
                if (metadata.versionChanged()) {
                    if (metadata.isVersionInternal()) {
                        request.setVersion(-3L);
                        request.setVersionType(VersionType.INTERNAL);
                    } else {
                        request.setVersion(metadata.getVersion());
                    }
                }
                if (metadata.routingChanged()) {
                    request.setRouting(metadata.getRouting());
                }
            }
        }
    }
}

