/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AuthorizationState
implements Writeable,
ToXContentObject {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);
    public static final ParseField LAST_AUTH_ERROR = new ParseField("last_auth_error", new String[0]);
    public static final ConstructingObjectParser<AuthorizationState, Void> PARSER = new ConstructingObjectParser("transform_authorization_state", true, a -> new AuthorizationState((Long)a[0], (HealthStatus)a[1], (String)a[2]));
    private final long timestampMillis;
    private final HealthStatus status;
    @Nullable
    private final String lastAuthError;

    public static AuthorizationState green() {
        return new AuthorizationState(System.currentTimeMillis(), HealthStatus.GREEN, null);
    }

    public static boolean isNullOrGreen(AuthorizationState authState) {
        return authState == null || HealthStatus.GREEN.equals((Object)authState.getStatus());
    }

    public static AuthorizationState red(Exception e) {
        return new AuthorizationState(System.currentTimeMillis(), HealthStatus.RED, e != null ? e.getMessage() : "unknown exception");
    }

    public AuthorizationState(Long timestamp, HealthStatus status, @Nullable String lastAuthError) {
        this.timestampMillis = timestamp;
        this.status = status;
        this.lastAuthError = lastAuthError;
    }

    public AuthorizationState(StreamInput in) throws IOException {
        this.timestampMillis = in.readLong();
        this.status = (HealthStatus)in.readEnum(HealthStatus.class);
        this.lastAuthError = in.readOptionalString();
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestampMillis);
    }

    public HealthStatus getStatus() {
        return this.status;
    }

    public String getLastAuthError() {
        return this.lastAuthError;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIMESTAMP.getPreferredName(), this.timestampMillis);
        builder.field(STATUS.getPreferredName(), this.status.xContentValue());
        if (this.lastAuthError != null) {
            builder.field(LAST_AUTH_ERROR.getPreferredName(), this.lastAuthError);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestampMillis);
        this.status.writeTo(out);
        out.writeOptionalString(this.lastAuthError);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AuthorizationState that = (AuthorizationState)other;
        return this.timestampMillis == that.timestampMillis && this.status.value() == that.status.value() && Objects.equals(this.lastAuthError, that.lastAuthError);
    }

    public int hashCode() {
        return Objects.hash(this.timestampMillis, this.status, this.lastAuthError);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return HealthStatus.valueOf((String)p.text().toUpperCase(Locale.ROOT));
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, STATUS, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), LAST_AUTH_ERROR);
    }
}

