/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.utils.TransformStrings;

public class PutTransformAction
extends ActionType<AcknowledgedResponse> {
    public static final PutTransformAction INSTANCE = new PutTransformAction();
    public static final String NAME = "cluster:admin/transform/put";
    private static final TimeValue MIN_FREQUENCY = TimeValue.timeValueSeconds((long)1L);
    private static final TimeValue MAX_FREQUENCY = TimeValue.timeValueHours((long)1L);

    private PutTransformAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TransformConfig config;
        private final boolean deferValidation;

        public Request(TransformConfig config, boolean deferValidation, TimeValue timeout) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, timeout);
            this.config = config;
            this.deferValidation = deferValidation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
            this.deferValidation = in.readBoolean();
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation, TimeValue timeout) {
            return new Request(TransformConfig.fromXContent(parser, id, false), deferValidation, timeout);
        }

        public ActionRequestValidationException validate() {
            TimeValue frequency;
            ActionRequestValidationException validationException = null;
            validationException = this.config.validate(validationException);
            validationException = SourceDestValidator.validateRequest(validationException, this.config.getDestination().getIndex());
            if (!TransformStrings.isValidId(this.config.getId())) {
                validationException = ValidateActions.addValidationError((String)TransformMessages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", TransformField.ID.getPreferredName(), this.config.getId()), (ActionRequestValidationException)validationException);
            }
            if (!TransformStrings.hasValidLengthForId(this.config.getId())) {
                validationException = ValidateActions.addValidationError((String)TransformMessages.getMessage("The id cannot contain more than {0} characters.", 64), (ActionRequestValidationException)validationException);
            }
            if ((frequency = this.config.getFrequency()) != null) {
                if (frequency.compareTo(MIN_FREQUENCY) < 0) {
                    validationException = ValidateActions.addValidationError((String)("minimum permitted [" + TransformField.FREQUENCY + "] is [" + MIN_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                } else if (frequency.compareTo(MAX_FREQUENCY) > 0) {
                    validationException = ValidateActions.addValidationError((String)("highest permitted [" + TransformField.FREQUENCY + "] is [" + MAX_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
            out.writeBoolean(this.deferValidation);
        }

        public int hashCode() {
            return Objects.hash(this.ackTimeout(), this.config, this.deferValidation);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.config, other.config) && this.deferValidation == other.deferValidation && this.ackTimeout().equals((Object)other.ackTimeout());
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }
    }
}

