/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.common.scheduler.TimeValueSchedule;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.GenerateSnapshotNameStep;
import org.elasticsearch.xpack.core.scheduler.Cron;
import org.elasticsearch.xpack.core.scheduler.CronSchedule;
import org.elasticsearch.xpack.core.slm.SnapshotRetentionConfiguration;

public class SnapshotLifecyclePolicy
implements SimpleDiffable<SnapshotLifecyclePolicy>,
Writeable,
ToXContentObject {
    private final String id;
    private final String name;
    private final String schedule;
    private final String repository;
    private final Map<String, Object> configuration;
    private final SnapshotRetentionConfiguration retentionPolicy;
    private final boolean isCronSchedule;
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField SCHEDULE = new ParseField("schedule", new String[0]);
    private static final ParseField REPOSITORY = new ParseField("repository", new String[0]);
    private static final ParseField CONFIG = new ParseField("config", new String[0]);
    private static final ParseField RETENTION = new ParseField("retention", new String[0]);
    private static final String METADATA_FIELD_NAME = "metadata";
    private static final ConstructingObjectParser<SnapshotLifecyclePolicy, String> PARSER = new ConstructingObjectParser("snapshot_lifecycle", true, (a, id) -> {
        String name = (String)a[0];
        String schedule = (String)a[1];
        String repo = (String)a[2];
        Map config = (Map)a[3];
        SnapshotRetentionConfiguration retention = (SnapshotRetentionConfiguration)a[4];
        return new SnapshotLifecyclePolicy((String)id, name, schedule, repo, config, retention);
    });

    public SnapshotLifecyclePolicy(String id, String name, String schedule, String repository, @Nullable Map<String, Object> configuration, @Nullable SnapshotRetentionConfiguration retentionPolicy) {
        this.id = Objects.requireNonNull(id, "policy id is required");
        this.name = Objects.requireNonNull(name, "policy snapshot name is required");
        this.schedule = Objects.requireNonNull(schedule, "policy schedule is required");
        this.repository = Objects.requireNonNull(repository, "policy snapshot repository is required");
        this.configuration = configuration;
        this.retentionPolicy = retentionPolicy;
        this.isCronSchedule = SnapshotLifecyclePolicy.isCronSchedule(schedule);
    }

    public SnapshotLifecyclePolicy(StreamInput in) throws IOException {
        this.id = in.readString();
        this.name = in.readString();
        this.schedule = in.readString();
        this.repository = in.readString();
        this.configuration = in.readGenericMap();
        this.retentionPolicy = (SnapshotRetentionConfiguration)in.readOptionalWriteable(SnapshotRetentionConfiguration::new);
        this.isCronSchedule = SnapshotLifecyclePolicy.isCronSchedule(this.schedule);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getRepository() {
        return this.repository;
    }

    @Nullable
    public Map<String, Object> getConfig() {
        return this.configuration;
    }

    @Nullable
    public SnapshotRetentionConfiguration getRetentionPolicy() {
        return this.retentionPolicy;
    }

    boolean isCronSchedule() {
        return this.isCronSchedule;
    }

    static boolean isCronSchedule(String schedule) {
        try {
            new Cron(schedule);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isIntervalSchedule(String schedule) {
        try {
            TimeValue.parseTimeValue((String)schedule, (String)"schedule");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public long calculateNextExecution(long modifiedDate, Clock clock) {
        if (this.isCronSchedule()) {
            Cron scheduleEvaluator = new Cron(this.schedule);
            return scheduleEvaluator.getNextValidTimeAfter(clock.millis());
        }
        TimeValue interval = TimeValue.parseTimeValue((String)this.schedule, (String)SCHEDULE.getPreferredName());
        TimeValueSchedule timeValueSchedule = new TimeValueSchedule(interval);
        return timeValueSchedule.nextScheduledTimeAfter(modifiedDate, clock.millis());
    }

    public TimeValue calculateNextInterval(Clock clock) {
        if (!this.isCronSchedule()) {
            return TimeValue.parseTimeValue((String)this.schedule, (String)SCHEDULE.getPreferredName());
        }
        Cron scheduleEvaluator = new Cron(this.schedule);
        long next1 = scheduleEvaluator.getNextValidTimeAfter(clock.millis());
        long next2 = scheduleEvaluator.getNextValidTimeAfter(next1);
        if (next1 > 0L && next2 > 0L) {
            return TimeValue.timeValueMillis((long)(next2 - next1));
        }
        return TimeValue.MINUS_ONE;
    }

    public SchedulerEngine.Job buildSchedulerJob(String jobId, long modifiedDate) {
        if (this.isCronSchedule()) {
            return new SchedulerEngine.Job(jobId, (SchedulerEngine.Schedule)new CronSchedule(this.schedule));
        }
        TimeValue timeValue = TimeValue.parseTimeValue((String)this.schedule, (String)"schedule");
        return new SchedulerEngine.Job(jobId, (SchedulerEngine.Schedule)new TimeValueSchedule(timeValue), Long.valueOf(modifiedDate));
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException err;
        block16: {
            String snapshotName;
            ActionRequestValidationException nameValidationErrors;
            int byteCount;
            err = new ActionRequestValidationException();
            if (!Strings.validFileName((String)this.id)) {
                err.addValidationError("invalid policy id [" + this.id + "]: must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
            }
            if (this.id.charAt(0) == '_') {
                err.addValidationError("invalid policy id [" + this.id + "]: must not start with '_'");
            }
            if ((byteCount = this.id.getBytes(StandardCharsets.UTF_8).length) > 255) {
                err.addValidationError("invalid policy id [" + this.id + "]: name is too long, (" + byteCount + " > 255 bytes)");
            }
            if ((nameValidationErrors = GenerateSnapshotNameStep.validateGeneratedSnapshotName(this.name, snapshotName = GenerateSnapshotNameStep.generateSnapshotName(this.name))) != null) {
                err.addValidationErrors((Iterable)nameValidationErrors.validationErrors());
            }
            if (!Strings.hasText((String)this.schedule)) {
                err.addValidationError("invalid schedule [" + this.schedule + "]: must not be empty");
            } else {
                try {
                    TimeValue intervalTimeValue = TimeValue.parseTimeValue((String)this.schedule, (String)SCHEDULE.getPreferredName());
                    if (intervalTimeValue.millis() == 0L) {
                        err.addValidationError("invalid schedule [" + this.schedule + "]: time unit must be at least 1 millisecond");
                    }
                }
                catch (IllegalArgumentException e1) {
                    if (SnapshotLifecyclePolicy.isCronSchedule(this.schedule)) break block16;
                    err.addValidationError("invalid schedule [" + this.schedule + "]: must be a valid cron expression or time unit");
                }
            }
        }
        if (this.configuration != null && this.configuration.containsKey(METADATA_FIELD_NAME)) {
            if (!(this.configuration.get(METADATA_FIELD_NAME) instanceof Map)) {
                err.addValidationError("invalid configuration.metadata [" + this.configuration.get(METADATA_FIELD_NAME) + "]: must be an object if present");
            } else {
                Map metadata = (Map)this.configuration.get(METADATA_FIELD_NAME);
                if (metadata.containsKey("policy")) {
                    err.addValidationError("invalid configuration.metadata: field name [policy] is reserved and will be added automatically");
                } else {
                    Map<String, Object> metadataWithPolicyField = this.addPolicyNameToMetadata(metadata);
                    int serializedSizeOriginal = CreateSnapshotRequest.metadataSize((Map)metadata);
                    int serializedSizeWithMetadata = CreateSnapshotRequest.metadataSize(metadataWithPolicyField);
                    int policyNameAddedBytes = serializedSizeWithMetadata - serializedSizeOriginal;
                    if (serializedSizeWithMetadata > CreateSnapshotRequest.MAXIMUM_METADATA_BYTES) {
                        err.addValidationError("invalid configuration.metadata: must be smaller than [" + (CreateSnapshotRequest.MAXIMUM_METADATA_BYTES - policyNameAddedBytes) + "] bytes, but is [" + serializedSizeOriginal + "] bytes");
                    }
                }
            }
        }
        if (!Strings.hasText((String)this.repository)) {
            err.addValidationError("invalid repository name [" + this.repository + "]: cannot be empty");
        }
        return err.validationErrors().size() == 0 ? null : err;
    }

    private Map<String, Object> addPolicyNameToMetadata(Map<String, Object> metadata) {
        HashMap<Object, Object> newMetadata = metadata == null ? new HashMap() : new HashMap<String, Object>(metadata);
        newMetadata.put("policy", this.id);
        return newMetadata;
    }

    public CreateSnapshotRequest toRequest(TimeValue masterNodeTimeout) {
        CreateSnapshotRequest req = new CreateSnapshotRequest(masterNodeTimeout, this.repository, GenerateSnapshotNameStep.generateSnapshotName(this.name));
        HashMap<String, Map<String, Object>> mergedConfiguration = this.configuration == null ? new HashMap<String, Map<String, Object>>() : new HashMap<String, Object>(this.configuration);
        Map metadata = (Map)mergedConfiguration.get(METADATA_FIELD_NAME);
        Map<String, Object> metadataWithAddedPolicyName = this.addPolicyNameToMetadata(metadata);
        mergedConfiguration.put(METADATA_FIELD_NAME, metadataWithAddedPolicyName);
        req.source(mergedConfiguration);
        req.waitForCompletion(true);
        return req;
    }

    public static SnapshotLifecyclePolicy parse(XContentParser parser, String id) {
        return (SnapshotLifecyclePolicy)PARSER.apply(parser, (Object)id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.schedule);
        out.writeString(this.repository);
        out.writeGenericMap(this.configuration);
        out.writeOptionalWriteable((Writeable)this.retentionPolicy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(SCHEDULE.getPreferredName(), this.schedule);
        builder.field(REPOSITORY.getPreferredName(), this.repository);
        if (this.configuration != null) {
            builder.field(CONFIG.getPreferredName(), this.configuration);
        }
        if (this.retentionPolicy != null) {
            builder.field(RETENTION.getPreferredName(), (ToXContent)this.retentionPolicy);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.schedule, this.repository, this.configuration, this.retentionPolicy);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecyclePolicy other = (SnapshotLifecyclePolicy)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.repository, other.repository) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.retentionPolicy, other.retentionPolicy);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SCHEDULE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REPOSITORY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), CONFIG);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotRetentionConfiguration::parse, RETENTION);
    }
}

