/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.lucene.util.BitSets;
import org.elasticsearch.lucene.util.MatchAllBitSet;

public final class DocumentSubsetBitsetCache
implements IndexReader.ClosedListener,
Closeable,
Accountable {
    private static final Logger logger = LogManager.getLogger(DocumentSubsetBitsetCache.class);
    static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.dls.bitset.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)2L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<ByteSizeValue> CACHE_SIZE_SETTING = Setting.memorySizeSetting((String)"xpack.security.dls.bitset.cache.size", (String)"10%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final BitSet NULL_MARKER = new FixedBitSet(0);
    private final long maxWeightBytes;
    private final Cache<BitsetCacheKey, BitSet> bitsetCache;
    private final Map<IndexReader.CacheKey, Set<BitsetCacheKey>> keysByIndex;
    private final AtomicLong cacheFullWarningTime;

    public DocumentSubsetBitsetCache(Settings settings) {
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        this.maxWeightBytes = ((ByteSizeValue)CACHE_SIZE_SETTING.get(settings)).getBytes();
        this.bitsetCache = CacheBuilder.builder().setExpireAfterAccess(ttl).setMaximumWeight(this.maxWeightBytes).weigher((key, bitSet) -> bitSet == NULL_MARKER ? 0L : bitSet.ramBytesUsed()).removalListener(this::onCacheEviction).build();
        this.keysByIndex = new ConcurrentHashMap<IndexReader.CacheKey, Set<BitsetCacheKey>>();
        this.cacheFullWarningTime = new AtomicLong(0L);
    }

    public void onClose(IndexReader.CacheKey indexKey) {
        Set<BitsetCacheKey> keys = this.keysByIndex.remove(indexKey);
        if (keys != null) {
            keys.forEach(arg_0 -> this.bitsetCache.invalidate(arg_0));
        }
    }

    private void onCacheEviction(RemovalNotification<BitsetCacheKey, BitSet> notification) {
        BitsetCacheKey cacheKey = (BitsetCacheKey)notification.getKey();
        IndexReader.CacheKey indexKey = cacheKey.indexKey;
        this.keysByIndex.computeIfPresent(indexKey, (ignored, keys) -> {
            keys.remove(cacheKey);
            return keys.isEmpty() ? null : keys;
        });
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        logger.debug("clearing all DLS bitsets because [{}]", (Object)reason);
        this.keysByIndex.clear();
        this.bitsetCache.invalidateAll();
    }

    int entryCount() {
        return this.bitsetCache.count();
    }

    public long ramBytesUsed() {
        return this.bitsetCache.weight();
    }

    @Nullable
    public BitSet getBitSet(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper coreCacheHelper = context.reader().getCoreCacheHelper();
        if (coreCacheHelper == null) {
            try {
                return DocumentSubsetBitsetCache.computeBitSet(query, context);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }
        coreCacheHelper.addClosedListener((IndexReader.ClosedListener)this);
        IndexReader.CacheKey indexKey = coreCacheHelper.getKey();
        BitsetCacheKey cacheKey = new BitsetCacheKey(indexKey, query);
        BitSet bitSet = (BitSet)this.bitsetCache.computeIfAbsent((Object)cacheKey, ignore1 -> {
            this.keysByIndex.compute(indexKey, (ignore2, keys) -> {
                if (keys == null) {
                    keys = ConcurrentCollections.newConcurrentSet();
                }
                keys.add(cacheKey);
                return keys;
            });
            BitSet result = DocumentSubsetBitsetCache.computeBitSet(query, context);
            if (result == null) {
                return NULL_MARKER;
            }
            long bitSetBytes = result.ramBytesUsed();
            if (bitSetBytes > this.maxWeightBytes) {
                logger.warn("built a DLS BitSet that uses [{}] bytes; the DLS BitSet cache has a maximum size of [{}] bytes; this object cannot be cached and will need to be rebuilt for each use; consider increasing the value of [{}]", (Object)bitSetBytes, (Object)this.maxWeightBytes, (Object)CACHE_SIZE_SETTING.getKey());
            } else if (bitSetBytes + this.bitsetCache.weight() > this.maxWeightBytes) {
                this.maybeLogCacheFullWarning();
            }
            return result;
        });
        if (bitSet == NULL_MARKER) {
            return null;
        }
        return bitSet;
    }

    @Nullable
    private static BitSet computeBitSet(Query query, LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Query rewrittenQuery = searcher.rewrite(query);
        if (DocumentSubsetBitsetCache.isEffectiveMatchAllDocsQuery(rewrittenQuery)) {
            return new MatchAllBitSet(context.reader().maxDoc());
        }
        Weight weight = searcher.createWeight(rewrittenQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer s = weight.scorer(context);
        if (s == null) {
            return null;
        }
        return BitSets.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc());
    }

    static boolean isEffectiveMatchAllDocsQuery(Query rewrittenQuery) {
        if (rewrittenQuery instanceof ConstantScoreQuery && ((ConstantScoreQuery)rewrittenQuery).getQuery() instanceof MatchAllDocsQuery) {
            return true;
        }
        return rewrittenQuery instanceof MatchAllDocsQuery;
    }

    private void maybeLogCacheFullWarning() {
        long now;
        long nextLogTime = this.cacheFullWarningTime.get();
        if (nextLogTime > (now = System.currentTimeMillis())) {
            return;
        }
        long nextCheck = now + TimeUnit.MINUTES.toMillis(30L);
        if (this.cacheFullWarningTime.compareAndSet(nextLogTime, nextCheck)) {
            logger.info("the Document Level Security BitSet cache is full which may impact performance; consider increasing the value of [{}]", (Object)CACHE_SIZE_SETTING.getKey());
        }
    }

    public static List<Setting<?>> getSettings() {
        return List.of(CACHE_TTL_SETTING, CACHE_SIZE_SETTING);
    }

    public Map<String, Object> usageStats() {
        ByteSizeValue ram = ByteSizeValue.ofBytes((long)this.ramBytesUsed());
        return Map.of("count", this.entryCount(), "memory", ram.toString(), "memory_in_bytes", ram.getBytes());
    }

    void verifyInternalConsistency() {
        this.verifyInternalConsistencyCacheToKeys();
        this.verifyInternalConsistencyKeysToCache();
    }

    void verifyInternalConsistencyCacheToKeys() {
        this.bitsetCache.keys().forEach(cacheKey -> {
            Set<BitsetCacheKey> keys = this.keysByIndex.get(cacheKey.indexKey);
            if (keys == null || !keys.contains(cacheKey)) {
                throw new IllegalStateException("Key [" + cacheKey + "] is in the cache, but the lookup entry for [" + cacheKey.indexKey + "] does not contain that key");
            }
        });
    }

    void verifyInternalConsistencyKeysToCache() {
        this.keysByIndex.forEach((indexKey, keys) -> {
            if (keys == null || keys.isEmpty()) {
                throw new IllegalStateException("The lookup entry for [" + indexKey + "] is null or empty");
            }
            keys.forEach(cacheKey -> {
                if (this.bitsetCache.get(cacheKey) == null) {
                    throw new IllegalStateException("Key [" + cacheKey + "] is in the lookup map, but is not in the cache");
                }
            });
        });
    }

    private static class BitsetCacheKey {
        final IndexReader.CacheKey indexKey;
        final Query query;

        private BitsetCacheKey(IndexReader.CacheKey indexKey, Query query) {
            this.indexKey = indexKey;
            this.query = query;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BitsetCacheKey that = (BitsetCacheKey)other;
            return Objects.equals(this.indexKey, that.indexKey) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.indexKey, this.query);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.indexKey + "," + this.query + ")";
        }
    }
}

