/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;

public interface AuthorizationEngine {
    public void resolveAuthorizationInfo(RequestInfo var1, ActionListener<AuthorizationInfo> var2);

    public void resolveAuthorizationInfo(Subject var1, ActionListener<AuthorizationInfo> var2);

    public void authorizeRunAs(RequestInfo var1, AuthorizationInfo var2, ActionListener<AuthorizationResult> var3);

    public void authorizeClusterAction(RequestInfo var1, AuthorizationInfo var2, ActionListener<AuthorizationResult> var3);

    public void authorizeIndexAction(RequestInfo var1, AuthorizationInfo var2, AsyncSupplier<ResolvedIndices> var3, Metadata var4, ActionListener<IndexAuthorizationResult> var5);

    public void loadAuthorizedIndices(RequestInfo var1, AuthorizationInfo var2, Map<String, IndexAbstraction> var3, ActionListener<AuthorizedIndices> var4);

    public void validateIndexPermissionsAreSubset(RequestInfo var1, AuthorizationInfo var2, Map<String, List<String>> var3, ActionListener<AuthorizationResult> var4);

    public void checkPrivileges(AuthorizationInfo var1, PrivilegesToCheck var2, Collection<ApplicationPrivilegeDescriptor> var3, ActionListener<PrivilegesCheckResult> var4);

    public void getUserPrivileges(AuthorizationInfo var1, @Nullable RoleReference.ApiKeyRoleType var2, ActionListener<GetUserPrivilegesResponse> var3);

    default public void getRoleDescriptorsIntersectionForRemoteCluster(String remoteClusterAlias, TransportVersion remoteClusterVersion, AuthorizationInfo authorizationInfo, ActionListener<RoleDescriptorsIntersection> listener) {
        throw new UnsupportedOperationException("retrieving role descriptors for remote cluster is not supported by this authorization engine");
    }

    @FunctionalInterface
    public static interface AsyncSupplier<V> {
        public void getAsync(ActionListener<V> var1);
    }

    public record ParentActionAuthorization(String action) implements Writeable
    {
        public static final String THREAD_CONTEXT_KEY = "_xpack_security_parent_action_authz";

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.action);
        }

        public static ParentActionAuthorization readFrom(StreamInput in) throws IOException {
            String action = in.readString();
            return new ParentActionAuthorization(action);
        }

        @Nullable
        public static ParentActionAuthorization readFromThreadContext(ThreadContext context) throws IOException {
            String header = context.getHeader(THREAD_CONTEXT_KEY);
            if (header == null) {
                return null;
            }
            byte[] bytes = Base64.getDecoder().decode(header);
            StreamInput input = StreamInput.wrap((byte[])bytes);
            return ParentActionAuthorization.readFrom(input);
        }

        public void writeToThreadContext(ThreadContext context) throws IOException {
            String header = this.encode();
            assert (header != null) : "parent authorization object encoded to null";
            context.putHeader(THREAD_CONTEXT_KEY, header);
        }

        private String encode() throws IOException {
            BytesStreamOutput output = new BytesStreamOutput();
            this.writeTo((StreamOutput)output);
            return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
        }
    }

    public static final class AuthorizationContext {
        private final String action;
        private final AuthorizationInfo authorizationInfo;
        private final IndicesAccessControl indicesAccessControl;

        public AuthorizationContext(String action, AuthorizationInfo authorizationInfo, IndicesAccessControl accessControl) {
            this.action = action;
            this.authorizationInfo = authorizationInfo;
            this.indicesAccessControl = accessControl;
        }

        public String getAction() {
            return this.action;
        }

        public AuthorizationInfo getAuthorizationInfo() {
            return this.authorizationInfo;
        }

        public IndicesAccessControl getIndicesAccessControl() {
            return this.indicesAccessControl;
        }
    }

    public static class IndexAuthorizationResult
    extends AuthorizationResult {
        public static final IndexAuthorizationResult DENIED = new IndexAuthorizationResult(IndicesAccessControl.DENIED);
        public static final IndexAuthorizationResult EMPTY = new IndexAuthorizationResult(null);
        public static final IndexAuthorizationResult ALLOW_NO_INDICES = new IndexAuthorizationResult(IndicesAccessControl.ALLOW_NO_INDICES);
        private final IndicesAccessControl indicesAccessControl;

        public IndexAuthorizationResult(IndicesAccessControl indicesAccessControl) {
            super(indicesAccessControl == null || indicesAccessControl.isGranted());
            this.indicesAccessControl = indicesAccessControl;
        }

        @Override
        public String getFailureContext(RequestInfo requestInfo, RestrictedIndices restrictedIndices) {
            if (this.isGranted()) {
                return null;
            }
            assert (this.indicesAccessControl != null);
            Object[] indices = RequestInfo.indices(requestInfo.getRequest());
            if (indices == null || indices.length == 0 || Arrays.equals(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY, indices)) {
                return null;
            }
            Set<String> deniedIndices = Arrays.stream(indices).filter(index -> false == this.indicesAccessControl.hasIndexPermissions((String)index)).collect(Collectors.toSet());
            return IndexAuthorizationResult.getFailureDescription(deniedIndices, restrictedIndices);
        }

        public static String getFailureDescription(Collection<String> deniedIndices, RestrictedIndices restrictedNames) {
            if (deniedIndices.isEmpty()) {
                return null;
            }
            StringBuilder regularIndices = new StringBuilder();
            StringBuilder restrictedIndices = new StringBuilder();
            for (String index : deniedIndices) {
                StringBuilder builder;
                StringBuilder stringBuilder = builder = restrictedNames.isRestricted(index) ? restrictedIndices : regularIndices;
                if (!builder.isEmpty()) {
                    builder.append(',');
                }
                builder.append(index);
            }
            StringBuilder message = new StringBuilder();
            if (!regularIndices.isEmpty()) {
                message.append("on indices [").append((CharSequence)regularIndices).append(']');
            }
            if (!restrictedIndices.isEmpty()) {
                message.append(message.length() == 0 ? "on" : " and").append(" restricted indices [").append((CharSequence)restrictedIndices).append(']');
            }
            return message.toString();
        }

        @Nullable
        public IndicesAccessControl getIndicesAccessControl() {
            return this.indicesAccessControl;
        }
    }

    public static class AuthorizationResult {
        private final boolean granted;

        public AuthorizationResult(boolean granted) {
            this.granted = granted;
        }

        public boolean isGranted() {
            return this.granted;
        }

        @Nullable
        public String getFailureContext(RequestInfo requestInfo, RestrictedIndices restrictedIndices) {
            return null;
        }

        public static AuthorizationResult granted() {
            return new AuthorizationResult(true);
        }

        public static AuthorizationResult deny() {
            return new AuthorizationResult(false);
        }
    }

    public static final class RequestInfo {
        private final Authentication authentication;
        private final TransportRequest request;
        private final String action;
        @Nullable
        private final AuthorizationContext originatingAuthorizationContext;
        @Nullable
        private final ParentActionAuthorization parentAuthorization;

        public RequestInfo(Authentication authentication, TransportRequest request, String action, AuthorizationContext originatingContext, ParentActionAuthorization parentAuthorization) {
            this.authentication = Objects.requireNonNull(authentication);
            this.request = Objects.requireNonNull(request);
            this.action = Objects.requireNonNull(action);
            this.originatingAuthorizationContext = originatingContext;
            this.parentAuthorization = parentAuthorization;
        }

        public RequestInfo(Authentication authentication, TransportRequest request, String action, AuthorizationContext originatingContext) {
            this(authentication, request, action, originatingContext, null);
        }

        public String getAction() {
            return this.action;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public TransportRequest getRequest() {
            return this.request;
        }

        @Nullable
        public AuthorizationContext getOriginatingAuthorizationContext() {
            return this.originatingAuthorizationContext;
        }

        @Nullable
        public ParentActionAuthorization getParentAuthorization() {
            return this.parentAuthorization;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{authentication=[" + this.authentication + "], request=[" + this.request + "], action=[" + this.action + "], originating=[" + this.originatingAuthorizationContext + "], parent=[" + this.parentAuthorization + "]}";
        }

        @Nullable
        public static String[] indices(TransportRequest transportRequest) {
            if (transportRequest instanceof IndicesRequest) {
                IndicesRequest indicesRequest = (IndicesRequest)transportRequest;
                return indicesRequest.indices();
            }
            return null;
        }
    }

    public static final class EmptyAuthorizationInfo
    implements AuthorizationInfo {
        public static final EmptyAuthorizationInfo INSTANCE = new EmptyAuthorizationInfo();

        private EmptyAuthorizationInfo() {
        }

        @Override
        public Map<String, Object> asMap() {
            return Collections.emptyMap();
        }
    }

    public static final class PrivilegesCheckResult {
        public static final PrivilegesCheckResult ALL_CHECKS_SUCCESS_NO_DETAILS = new PrivilegesCheckResult(true, null);
        public static final PrivilegesCheckResult SOME_CHECKS_FAILURE_NO_DETAILS = new PrivilegesCheckResult(false, null);
        private final boolean allChecksSuccess;
        @Nullable
        private final Details details;

        public PrivilegesCheckResult(boolean allChecksSuccess, Details details) {
            this.allChecksSuccess = allChecksSuccess;
            this.details = details;
        }

        public boolean allChecksSuccess() {
            return this.allChecksSuccess;
        }

        @Nullable
        public Details getDetails() {
            return this.details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivilegesCheckResult that = (PrivilegesCheckResult)o;
            return this.allChecksSuccess == that.allChecksSuccess && Objects.equals(this.details, that.details);
        }

        public int hashCode() {
            return Objects.hash(this.allChecksSuccess, this.details);
        }

        public record Details(Map<String, Boolean> cluster, Map<String, ResourcePrivileges> index, Map<String, Collection<ResourcePrivileges>> application) {
            public Details {
                Objects.requireNonNull(cluster);
                Objects.requireNonNull(index);
                Objects.requireNonNull(application);
            }
        }
    }

    public record PrivilegesToCheck(String[] cluster, RoleDescriptor.IndicesPrivileges[] index, RoleDescriptor.ApplicationResourcePrivileges[] application, boolean runDetailedCheck) {
        public static PrivilegesToCheck readFrom(StreamInput in) throws IOException {
            return new PrivilegesToCheck(in.readOptionalStringArray(), (RoleDescriptor.IndicesPrivileges[])in.readOptionalArray(RoleDescriptor.IndicesPrivileges::new, RoleDescriptor.IndicesPrivileges[]::new), (RoleDescriptor.ApplicationResourcePrivileges[])in.readOptionalArray(RoleDescriptor.ApplicationResourcePrivileges::new, RoleDescriptor.ApplicationResourcePrivileges[]::new), in.readBoolean());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalStringArray(this.cluster);
            out.writeOptionalArray(RoleDescriptor.IndicesPrivileges::write, (Object[])this.index);
            out.writeOptionalArray(RoleDescriptor.ApplicationResourcePrivileges::write, (Object[])this.application);
            out.writeBoolean(this.runDetailedCheck);
        }

        public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
            if (this.cluster == null) {
                validationException = ValidateActions.addValidationError((String)"clusterPrivileges must not be null", (ActionRequestValidationException)validationException);
            }
            if (this.index == null) {
                validationException = ValidateActions.addValidationError((String)"indexPrivileges must not be null", (ActionRequestValidationException)validationException);
            } else {
                block2: for (RoleDescriptor.IndicesPrivileges indicesPrivileges : this.index) {
                    BytesReference query = indicesPrivileges.getQuery();
                    if (query != null) {
                        validationException = ValidateActions.addValidationError((String)("may only check index privileges without any DLS query [" + query.utf8ToString() + "]"), (ActionRequestValidationException)validationException);
                    }
                    for (String indexPattern : indicesPrivileges.getIndices()) {
                        if (!IndexNameExpressionResolver.hasSelector((String)indexPattern, (IndexComponentSelector)IndexComponentSelector.FAILURES) && !IndexNameExpressionResolver.hasSelector((String)indexPattern, (IndexComponentSelector)IndexComponentSelector.DATA)) continue;
                        validationException = ValidateActions.addValidationError((String)("may only check index privileges without selectors in index patterns [" + indexPattern + "]"), (ActionRequestValidationException)validationException);
                        continue block2;
                    }
                }
            }
            if (this.application == null) {
                validationException = ValidateActions.addValidationError((String)"applicationPrivileges must not be null", (ActionRequestValidationException)validationException);
            } else {
                for (RoleDescriptor.ApplicationResourcePrivileges applicationPrivilege : this.application) {
                    try {
                        ApplicationPrivilege.validateApplicationName(applicationPrivilege.getApplication());
                    }
                    catch (IllegalArgumentException e) {
                        validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                    }
                }
            }
            if (this.cluster != null && this.cluster.length == 0 && this.index != null && this.index.length == 0 && this.application != null && this.application.length == 0) {
                validationException = ValidateActions.addValidationError((String)"must specify at least one privilege", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivilegesToCheck that = (PrivilegesToCheck)o;
            return this.runDetailedCheck == that.runDetailedCheck && Arrays.equals(this.cluster, that.cluster) && Arrays.equals(this.index, that.index) && Arrays.equals(this.application, that.application);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.runDetailedCheck);
            result = 31 * result + Arrays.hashCode(this.cluster);
            result = 31 * result + Arrays.hashCode(this.index);
            result = 31 * result + Arrays.hashCode(this.application);
            return result;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{cluster=" + Arrays.toString(this.cluster) + ",index=" + Arrays.toString(this.index) + ",application=" + Arrays.toString(this.application) + ",detailed=" + this.runDetailedCheck + "}";
        }
    }

    public static interface AuthorizedIndices {
        public Set<String> all(IndexComponentSelector var1);

        public boolean check(String var1, IndexComponentSelector var2);
    }

    public static interface AuthorizationInfo {
        public Map<String, Object> asMap();

        default public AuthorizationInfo getAuthenticatedUserAuthorizationInfo() {
            return this;
        }
    }
}

