/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.user.User;

public final class QueryUserResponse
extends ActionResponse
implements ToXContentObject {
    private final long total;
    private final Item[] items;

    public QueryUserResponse(long total, Collection<Item> items) {
        this.total = total;
        Objects.requireNonNull(items, "items must be provided");
        this.items = items.toArray(new Item[0]);
    }

    public long getTotal() {
        return this.total;
    }

    public Item[] getItems() {
        return this.items;
    }

    public int getCount() {
        return this.items.length;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("total", this.total).field("count", this.items.length).array("users", (Object[])this.items);
        return builder.endObject();
    }

    public String toString() {
        return "QueryUsersResponse{total=" + this.total + ", items=" + Arrays.toString(this.items) + "}";
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public record Item(User user, @Nullable Object[] sortValues, @Nullable String profileUid) implements ToXContentObject
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.user.innerToXContent(builder);
            if (this.sortValues != null && this.sortValues.length > 0) {
                builder.array("_sort", this.sortValues);
            }
            if (this.profileUid != null) {
                builder.field("profile_uid", this.profileUid);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return "Item{user=" + this.user + ", sortValues=" + Arrays.toString(this.sortValues) + "}";
        }
    }
}

