/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexComponentSelectorPredicate;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.restriction.WorkflowResolver;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.support.Validation;

public class RoleDescriptorRequestValidator {
    private RoleDescriptorRequestValidator() {
    }

    public static ActionRequestValidationException validate(RoleDescriptor roleDescriptor) {
        return RoleDescriptorRequestValidator.validate(roleDescriptor, null);
    }

    public static ActionRequestValidationException validate(RoleDescriptor roleDescriptor, ActionRequestValidationException validationException) {
        Validation.Error error;
        RoleDescriptor.RemoteIndicesPrivileges[] remoteIndicesPrivileges;
        if (roleDescriptor.getName() == null) {
            validationException = ValidateActions.addValidationError((String)"role name is missing", (ActionRequestValidationException)validationException);
        }
        if (roleDescriptor.getClusterPrivileges() != null) {
            for (String cp : roleDescriptor.getClusterPrivileges()) {
                try {
                    ClusterPrivilegeResolver.resolve(cp);
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (roleDescriptor.getIndicesPrivileges() != null) {
            for (RoleDescriptor.IndicesPrivileges idp : roleDescriptor.getIndicesPrivileges()) {
                try {
                    IndexPrivilege.resolveBySelectorAccess(Set.of(idp.getPrivileges()));
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
                }
                for (String indexName : idp.getIndices()) {
                    validationException = RoleDescriptorRequestValidator.validateIndexNameExpression(indexName, validationException);
                }
            }
        }
        for (RoleDescriptor.RemoteIndicesPrivileges ridp : remoteIndicesPrivileges = roleDescriptor.getRemoteIndicesPrivileges()) {
            if (Arrays.asList(ridp.remoteClusters()).contains("")) {
                validationException = ValidateActions.addValidationError((String)"remote index cluster alias cannot be an empty string", (ActionRequestValidationException)validationException);
            }
            try {
                Set<IndexPrivilege> privileges = IndexPrivilege.resolveBySelectorAccess(Set.of(ridp.indicesPrivileges().getPrivileges()));
                if (privileges.stream().anyMatch(p -> p.getSelectorPredicate() == IndexComponentSelectorPredicate.FAILURES)) {
                    validationException = ValidateActions.addValidationError((String)"remote index privileges cannot contain privileges that grant access to the failure store", (ActionRequestValidationException)validationException);
                }
            }
            catch (IllegalArgumentException ile) {
                validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
            }
            for (String indexName : ridp.indicesPrivileges().getIndices()) {
                validationException = RoleDescriptorRequestValidator.validateIndexNameExpression(indexName, validationException);
            }
        }
        if (roleDescriptor.hasRemoteClusterPermissions()) {
            try {
                roleDescriptor.getRemoteClusterPermissions().validate();
            }
            catch (IllegalArgumentException e) {
                validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
            }
        }
        if (roleDescriptor.getApplicationPrivileges() != null) {
            for (RoleDescriptor.ApplicationResourcePrivileges privilege : roleDescriptor.getApplicationPrivileges()) {
                try {
                    ApplicationPrivilege.validateApplicationNameOrWildcard(privilege.getApplication());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                }
                for (String privilegeName : privilege.getPrivileges()) {
                    try {
                        ApplicationPrivilege.validatePrivilegeOrActionName(privilegeName);
                    }
                    catch (IllegalArgumentException e) {
                        validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                    }
                }
            }
        }
        if (roleDescriptor.getMetadata() != null && MetadataUtils.containsReservedMetadata(roleDescriptor.getMetadata())) {
            validationException = ValidateActions.addValidationError((String)"role descriptor metadata keys may not start with [_]", (ActionRequestValidationException)validationException);
        }
        if (roleDescriptor.hasWorkflowsRestriction()) {
            for (String workflowName : roleDescriptor.getRestriction().getWorkflows()) {
                try {
                    WorkflowResolver.resolveWorkflowByName(workflowName);
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (roleDescriptor.hasDescription() && (error = Validation.Roles.validateRoleDescription(roleDescriptor.getDescription())) != null) {
            validationException = ValidateActions.addValidationError((String)error.toString(), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateIndexNameExpression(String indexNameExpression, ActionRequestValidationException validationException) {
        if (IndexNameExpressionResolver.hasSelectorSuffix((String)indexNameExpression)) {
            validationException = ValidateActions.addValidationError((String)("selectors [::] are not allowed in the index name expression [" + indexNameExpression + "]"), (ActionRequestValidationException)validationException);
        }
        if (indexNameExpression != null) {
            if (indexNameExpression.startsWith("/")) {
                if (indexNameExpression.length() == 1 || !indexNameExpression.endsWith("/")) {
                    return ValidateActions.addValidationError((String)("invalid regular expression pattern [" + indexNameExpression + "]"), (ActionRequestValidationException)validationException);
                }
                String regex = indexNameExpression.substring(1, indexNameExpression.length() - 1);
                try {
                    new RegExp(regex);
                }
                catch (IllegalArgumentException e) {
                    return ValidateActions.addValidationError((String)("invalid regular expression pattern [" + indexNameExpression + "]"), (ActionRequestValidationException)validationException);
                }
            } else if (indexNameExpression.contains(",")) {
                validationException = ValidateActions.addValidationError((String)("commas [,] are not allowed in the index name expression [" + indexNameExpression + "]"), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }
}

