/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.scheduler;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;

public class LocalDateTimeLegacyWrapper {
    private LocalDateTime ldt;

    public LocalDateTimeLegacyWrapper(LocalDateTime ldt) {
        this.ldt = ldt;
    }

    public int getYear() {
        return this.ldt.getYear();
    }

    public int getDayOfMonth() {
        return this.ldt.getDayOfMonth();
    }

    public int getHour() {
        return this.ldt.getHour();
    }

    public int getMinute() {
        return this.ldt.getMinute();
    }

    public int getSecond() {
        return this.ldt.getSecond();
    }

    public int getDayOfWeek() {
        return this.ldt.getDayOfWeek().getValue() % 7 + 1;
    }

    public int getMonth() {
        return this.ldt.getMonthValue() - 1;
    }

    public void setYear(int year) {
        this.ldt = this.ldt.withYear(year);
    }

    public void setDayOfMonth(int dayOfMonth) {
        int lengthOfMonth = this.ldt.getMonth().length(this.ldt.toLocalDate().isLeapYear());
        if (dayOfMonth <= lengthOfMonth) {
            this.ldt = this.ldt.withDayOfMonth(dayOfMonth);
        } else {
            int months = dayOfMonth / lengthOfMonth;
            int day = dayOfMonth % lengthOfMonth;
            this.ldt = this.ldt.plusMonths(months).withDayOfMonth(day);
        }
    }

    public void setMonth(int month) {
        if (++month <= 12) {
            this.ldt = this.ldt.withMonth(month);
        } else {
            int years = month / 12;
            int monthOfYear = month % 12;
            this.ldt = this.ldt.plusYears(years).withMonth(monthOfYear);
        }
    }

    public void setHour(int hour) {
        if (hour < 24) {
            this.ldt = this.ldt.withHour(hour);
        } else {
            int days = hour / 24;
            int hourOfDay = hour % 24;
            this.ldt = this.ldt.plusDays(days).withHour(hourOfDay);
        }
    }

    public void setMinute(int minute) {
        if (minute < 60) {
            this.ldt = this.ldt.withMinute(minute);
        } else {
            int hours = minute / 60;
            int minuteOfHour = minute % 60;
            this.ldt = this.ldt.plusHours(hours).withMinute(minuteOfHour);
        }
    }

    public void setSecond(int second) {
        if (second < 60) {
            this.ldt = this.ldt.withSecond(second);
        } else {
            int minutes = second / 60;
            int secondOfMinute = second % 60;
            this.ldt = this.ldt.plusMinutes(minutes).withSecond(secondOfMinute);
        }
    }

    public void plusYears(long years) {
        this.ldt = this.ldt.plusYears(years);
    }

    public void plusSeconds(long seconds) {
        this.ldt = this.ldt.plusSeconds(seconds);
    }

    public boolean isAfter(ChronoLocalDateTime<?> other) {
        return this.ldt.isAfter(other);
    }

    public boolean isBefore(ChronoLocalDateTime<?> other) {
        return this.ldt.isBefore(other);
    }

    public LocalDateTime getLocalDateTime() {
        return this.ldt;
    }
}

