/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class RuntimeMappingsValidator {
    public static void validate(Map<String, Object> runtimeMappings) {
        for (Map.Entry<String, Object> entry : runtimeMappings.entrySet()) {
            String fieldName = entry.getKey();
            if (entry.getValue() instanceof Map) {
                HashMap propNode = new HashMap((Map)entry.getValue());
                Object typeNode = propNode.get("type");
                if (typeNode != null) continue;
                throw ExceptionsHelper.badRequestException("No type specified for runtime field [{}]", fieldName);
            }
            throw ExceptionsHelper.badRequestException("Expected map for runtime field [{}] definition but got a {}", fieldName, fieldName.getClass().getSimpleName());
        }
    }
}

