/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.TokenPruningConfig;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.CoordinatedInferenceAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.inference.results.WarningInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfigUpdate;

public class SparseVectorQueryBuilder
extends AbstractQueryBuilder<SparseVectorQueryBuilder> {
    public static final String NAME = "sparse_vector";
    public static final String ALLOWED_FIELD_TYPE = "sparse_vector";
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField QUERY_VECTOR_FIELD = new ParseField("query_vector", new String[0]);
    public static final ParseField INFERENCE_ID_FIELD = new ParseField("inference_id", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField PRUNE_FIELD = new ParseField("prune", new String[0]);
    public static final ParseField PRUNING_CONFIG_FIELD = new ParseField("pruning_config", new String[0]);
    private static final boolean DEFAULT_PRUNE = false;
    private static final TransportVersion SPARSE_VECTOR_FIELD_PRUNING_OPTIONS = TransportVersion.fromName((String)"sparse_vector_field_pruning_options");
    private final String fieldName;
    private final List<WeightedToken> queryVectors;
    private final String inferenceId;
    private final String query;
    private final Boolean shouldPruneTokens;
    private final SetOnce<TextExpansionResults> weightedTokensSupplier;
    @Nullable
    private final TokenPruningConfig tokenPruningConfig;
    private static final ConstructingObjectParser<SparseVectorQueryBuilder, Void> PARSER = new ConstructingObjectParser("sparse_vector", a -> {
        String fieldName = (String)a[0];
        List<WeightedToken> weightedTokens = SparseVectorQueryBuilder.parseWeightedTokens((Map)a[1]);
        String inferenceId = (String)a[2];
        String text = (String)a[3];
        Boolean shouldPruneTokens = (Boolean)a[4];
        TokenPruningConfig tokenPruningConfig = (TokenPruningConfig)a[5];
        return new SparseVectorQueryBuilder(fieldName, weightedTokens, inferenceId, text, shouldPruneTokens, tokenPruningConfig);
    });

    public SparseVectorQueryBuilder(String fieldName, String inferenceId, String query) {
        this(fieldName, null, inferenceId, query, false, null);
    }

    public SparseVectorQueryBuilder(String fieldName, @Nullable List<WeightedToken> queryVectors, @Nullable String inferenceId, @Nullable String query, @Nullable Boolean shouldPruneTokens, @Nullable TokenPruningConfig tokenPruningConfig) {
        this.fieldName = Objects.requireNonNull(fieldName, "[sparse_vector] requires a [" + FIELD_FIELD.getPreferredName() + "]");
        this.shouldPruneTokens = shouldPruneTokens;
        this.queryVectors = queryVectors;
        this.inferenceId = inferenceId;
        this.query = query;
        this.tokenPruningConfig = tokenPruningConfig;
        this.weightedTokensSupplier = null;
        if (queryVectors != null && inferenceId != null) {
            throw new IllegalArgumentException("[sparse_vector] requires one of [" + QUERY_VECTOR_FIELD.getPreferredName() + "] or [" + INFERENCE_ID_FIELD.getPreferredName() + "] for sparse_vector fields");
        }
        if (queryVectors == null == (query == null)) {
            throw new IllegalArgumentException("[sparse_vector] requires one of [" + QUERY_VECTOR_FIELD.getPreferredName() + "] or [" + INFERENCE_ID_FIELD.getPreferredName() + "] for sparse_vector fields");
        }
    }

    public SparseVectorQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.shouldPruneTokens = in.getTransportVersion().supports(SPARSE_VECTOR_FIELD_PRUNING_OPTIONS) ? in.readOptionalBoolean() : Boolean.valueOf(in.readBoolean());
        this.queryVectors = in.readOptionalCollectionAsList(WeightedToken::new);
        this.inferenceId = in.readOptionalString();
        this.query = in.readOptionalString();
        this.tokenPruningConfig = (TokenPruningConfig)in.readOptionalWriteable(TokenPruningConfig::new);
        this.weightedTokensSupplier = null;
    }

    private SparseVectorQueryBuilder(SparseVectorQueryBuilder other, SetOnce<TextExpansionResults> weightedTokensSupplier) {
        this.fieldName = other.fieldName;
        this.shouldPruneTokens = other.shouldPruneTokens;
        this.queryVectors = other.queryVectors;
        this.inferenceId = other.inferenceId;
        this.query = other.query;
        this.tokenPruningConfig = other.tokenPruningConfig;
        this.weightedTokensSupplier = weightedTokensSupplier;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<WeightedToken> getQueryVectors() {
        return this.queryVectors;
    }

    public String getInferenceId() {
        return this.inferenceId;
    }

    public String getQuery() {
        return this.query;
    }

    public Boolean shouldPruneTokens() {
        return this.shouldPruneTokens;
    }

    public TokenPruningConfig getTokenPruningConfig() {
        return this.tokenPruningConfig;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.weightedTokensSupplier != null) {
            throw new IllegalStateException("weighted tokens supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        if (out.getTransportVersion().supports(SPARSE_VECTOR_FIELD_PRUNING_OPTIONS)) {
            out.writeOptionalBoolean(this.shouldPruneTokens);
        } else {
            out.writeBoolean(this.shouldPruneTokens.booleanValue());
        }
        out.writeOptionalCollection(this.queryVectors);
        out.writeOptionalString(this.inferenceId);
        out.writeOptionalString(this.query);
        out.writeOptionalWriteable((Writeable)this.tokenPruningConfig);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("sparse_vector");
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        if (this.queryVectors != null) {
            builder.startObject(QUERY_VECTOR_FIELD.getPreferredName());
            for (WeightedToken token : this.queryVectors) {
                token.toXContent(builder, params);
            }
            builder.endObject();
        } else {
            if (this.inferenceId != null) {
                builder.field(INFERENCE_ID_FIELD.getPreferredName(), this.inferenceId);
            }
            builder.field(QUERY_FIELD.getPreferredName(), this.query);
        }
        if (this.shouldPruneTokens != null) {
            builder.field(PRUNE_FIELD.getPreferredName(), this.shouldPruneTokens);
        }
        if (this.tokenPruningConfig != null) {
            builder.field(PRUNING_CONFIG_FIELD.getPreferredName(), (ToXContent)this.tokenPruningConfig);
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        if (this.queryVectors == null) {
            return new MatchNoDocsQuery("Empty query vectors");
        }
        MappedFieldType ft = context.getFieldType(this.fieldName);
        if (ft == null) {
            return new MatchNoDocsQuery("The \"" + this.getName() + "\" query is against a field that does not exist");
        }
        if (ft instanceof SparseVectorFieldMapper.SparseVectorFieldType) {
            SparseVectorFieldMapper.SparseVectorFieldType svft = (SparseVectorFieldMapper.SparseVectorFieldType)ft;
            return svft.finalizeSparseVectorQuery(context, this.fieldName, this.queryVectors, this.shouldPruneTokens, this.tokenPruningConfig);
        }
        throw new IllegalArgumentException("field [" + this.fieldName + "] must be type [sparse_vector] but is type [" + ft.typeName() + "]");
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (this.queryVectors != null) {
            return this;
        }
        if (this.weightedTokensSupplier != null) {
            TextExpansionResults textExpansionResults = (TextExpansionResults)this.weightedTokensSupplier.get();
            if (textExpansionResults == null) {
                return this;
            }
            return new SparseVectorQueryBuilder(this.fieldName, textExpansionResults.getWeightedTokens(), null, null, this.shouldPruneTokens, this.tokenPruningConfig);
        }
        if (this.inferenceId == null) {
            throw new IllegalArgumentException("inference_id required to perform vector search on query string");
        }
        CoordinatedInferenceAction.Request inferRequest = CoordinatedInferenceAction.Request.forTextInput(this.inferenceId, List.of(this.query), TextExpansionConfigUpdate.EMPTY_UPDATE, false, InferModelAction.Request.DEFAULT_TIMEOUT_FOR_API);
        inferRequest.setHighPriority(true);
        inferRequest.setPrefixType(TrainedModelPrefixStrings.PrefixType.SEARCH);
        SetOnce textExpansionResultsSupplier = new SetOnce();
        queryRewriteContext.registerAsyncAction((client, listener) -> ClientHelper.executeAsyncWithOrigin(client, "ml", CoordinatedInferenceAction.INSTANCE, inferRequest, ActionListener.wrap(inferenceResponse -> {
            List<InferenceResults> inferenceResults = inferenceResponse.getInferenceResults();
            if (inferenceResults.isEmpty()) {
                listener.onFailure((Exception)new IllegalStateException("inference response contain no results"));
                return;
            }
            if (inferenceResults.size() > 1) {
                listener.onFailure((Exception)new IllegalStateException("inference response should contain only one result"));
                return;
            }
            InferenceResults patt12390$temp = inferenceResults.get(0);
            if (patt12390$temp instanceof TextExpansionResults) {
                TextExpansionResults textExpansionResults = (TextExpansionResults)patt12390$temp;
                textExpansionResultsSupplier.set((Object)textExpansionResults);
                listener.onResponse(null);
            } else {
                InferenceResults patt12632$temp = inferenceResults.get(0);
                if (patt12632$temp instanceof WarningInferenceResults) {
                    WarningInferenceResults warning = (WarningInferenceResults)patt12632$temp;
                    listener.onFailure((Exception)new IllegalStateException(warning.getWarning()));
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("expected a result of type [text_expansion_result] received [" + inferenceResults.get(0).getWriteableName() + "]. Is [" + this.inferenceId + "] a compatible model?"));
                }
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        return new SparseVectorQueryBuilder(this, (SetOnce<TextExpansionResults>)textExpansionResultsSupplier);
    }

    protected boolean doEquals(SparseVectorQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.tokenPruningConfig, other.tokenPruningConfig) && Objects.equals(this.queryVectors, other.queryVectors) && Objects.equals(this.shouldPruneTokens, other.shouldPruneTokens) && Objects.equals(this.inferenceId, other.inferenceId) && Objects.equals(this.query, other.query);
    }

    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.queryVectors, this.tokenPruningConfig, this.shouldPruneTokens, this.inferenceId, this.query);
    }

    public String getWriteableName() {
        return "sparse_vector";
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    private static List<WeightedToken> parseWeightedTokens(Map<String, Object> weightedTokenMap) {
        ArrayList<WeightedToken> weightedTokens = null;
        if (weightedTokenMap != null) {
            weightedTokens = new ArrayList<WeightedToken>();
            for (Map.Entry<String, Object> entry : weightedTokenMap.entrySet()) {
                String token = entry.getKey();
                Object weight = entry.getValue();
                if (weight instanceof Number) {
                    Number number = (Number)weight;
                    WeightedToken weightedToken = new WeightedToken(token, number.floatValue());
                    weightedTokens.add(weightedToken);
                    continue;
                }
                throw new IllegalArgumentException("weight must be a number, was [" + weight + "]");
            }
        }
        return weightedTokens;
    }

    public static SparseVectorQueryBuilder fromXContent(XContentParser parser) {
        try {
            return (SparseVectorQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), QUERY_VECTOR_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INFERENCE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), QUERY_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), PRUNE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TokenPruningConfig.fromXContent((XContentParser)p), PRUNING_CONFIG_FIELD);
        SparseVectorQueryBuilder.declareStandardFields(PARSER);
    }
}

