/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference;

import java.util.Map;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.RegressionInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.BoundedInferenceModel;

public class BoundedWindowInferenceModel
implements BoundedInferenceModel {
    public static final double DEFAULT_MIN_PREDICTED_VALUE = 0.0;
    private final BoundedInferenceModel model;
    private final double minPredictedValue;
    private final double maxPredictedValue;
    private final double adjustmentValue;

    public BoundedWindowInferenceModel(BoundedInferenceModel model) {
        this.model = model;
        this.minPredictedValue = model.getMinPredictedValue();
        this.maxPredictedValue = model.getMaxPredictedValue();
        this.adjustmentValue = this.minPredictedValue < 0.0 ? 0.0 - this.minPredictedValue : 0.0;
    }

    @Override
    public String[] getFeatureNames() {
        return this.model.getFeatureNames();
    }

    @Override
    public TargetType targetType() {
        return this.model.targetType();
    }

    @Override
    public InferenceResults infer(Map<String, Object> fields, InferenceConfig config, Map<String, String> featureDecoderMap) {
        return this.boundInferenceResultScores(this.model.infer(fields, config, featureDecoderMap));
    }

    @Override
    public InferenceResults infer(double[] features, InferenceConfig config) {
        return this.boundInferenceResultScores(this.model.infer(features, config));
    }

    @Override
    public boolean supportsFeatureImportance() {
        return this.model.supportsFeatureImportance();
    }

    @Override
    public String getName() {
        return "bounded_window[" + this.model.getName() + "]";
    }

    @Override
    public void rewriteFeatureIndices(Map<String, Integer> newFeatureIndexMapping) {
        this.model.rewriteFeatureIndices(newFeatureIndexMapping);
    }

    public long ramBytesUsed() {
        return this.model.ramBytesUsed();
    }

    @Override
    public double getMinPredictedValue() {
        return this.minPredictedValue;
    }

    @Override
    public double getMaxPredictedValue() {
        return this.maxPredictedValue;
    }

    private InferenceResults boundInferenceResultScores(InferenceResults inferenceResult) {
        if (inferenceResult instanceof RegressionInferenceResults) {
            RegressionInferenceResults regressionInferenceResults = (RegressionInferenceResults)inferenceResult;
            double predictedValue = ((Number)regressionInferenceResults.predictedValue()).doubleValue();
            return new RegressionInferenceResults(predictedValue += this.adjustmentValue, inferenceResult.getResultsField(), ((RegressionInferenceResults)inferenceResult).getFeatureImportance());
        }
        throw new IllegalStateException(LoggerMessageFormat.format((String)"Model used within a {} should return a {} but got {} instead", (String)BoundedWindowInferenceModel.class.getSimpleName(), (Object[])new Object[]{RegressionInferenceResults.class.getSimpleName(), inferenceResult.getClass().getSimpleName()}));
    }

    public String toString() {
        return "BoundedWindowInferenceModel{model=" + this.model + ", minPredictedValue=" + this.getMinPredictedValue() + ", maxPredictedValue=" + this.getMaxPredictedValue() + "}";
    }
}

