/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteCalendarAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteCalendarAction INSTANCE = new DeleteCalendarAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/delete";

    private DeleteCalendarAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String calendarId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readString();
        }

        public Request(String calendarId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId);
        }

        public boolean equals(Object obj) {
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId);
        }
    }
}

