/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;

public class LifecyclePolicyUsageCalculator {
    private final Map<String, List<String>> policyToTemplates;
    private final Map<String, List<String>> policyToDataStreams;
    private final Map<String, List<String>> policyToIndices;

    public LifecyclePolicyUsageCalculator(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState state, List<String> requestedPolicyNames) {
        Metadata metadata = state.metadata();
        IndexLifecycleMetadata ilmMetadata = (IndexLifecycleMetadata)metadata.custom("index_lifecycle");
        int expectedSize = Regex.isSimpleMatchPattern((String)requestedPolicyNames.get(0)) ? ilmMetadata.getPolicyMetadatas().size() : requestedPolicyNames.size();
        HashMap<String, String> templateToPolicy = new HashMap<String, String>();
        this.policyToTemplates = Maps.newHashMapWithExpectedSize((int)expectedSize);
        for (Map.Entry entry2 : metadata.templatesV2().entrySet()) {
            Settings settings = MetadataIndexTemplateService.resolveSettings((ComposableIndexTemplate)((ComposableIndexTemplate)entry2.getValue()), (Map)metadata.componentTemplates());
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings);
            if (!this.doesPolicyMatchAnyName(policyName, requestedPolicyNames)) continue;
            this.policyToTemplates.computeIfAbsent(policyName, k -> new ArrayList()).add((String)entry2.getKey());
            templateToPolicy.put((String)entry2.getKey(), policyName);
        }
        ArrayList indexTemplates = new ArrayList(metadata.templatesV2().entrySet());
        CollectionUtil.timSort(indexTemplates, Comparator.comparing(entry -> ((ComposableIndexTemplate)entry.getValue()).priorityOrZero(), Comparator.reverseOrder()));
        this.policyToDataStreams = Maps.newHashMapWithExpectedSize((int)expectedSize);
        List allDataStreams = indexNameExpressionResolver.dataStreamNames(state, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTOR, new String[0]);
        for (String dataStream : allDataStreams) {
            String indexTemplate = MetadataIndexTemplateService.findV2TemplateFromSortedList((Metadata)metadata, indexTemplates, (String)dataStream, (boolean)false);
            if (indexTemplate == null) {
                assert (false) : "Data stream [" + dataStream + "] has no matching template";
                continue;
            }
            String policyName = (String)templateToPolicy.get(indexTemplate);
            if (policyName == null) continue;
            this.policyToDataStreams.computeIfAbsent(policyName, k -> new ArrayList()).add(dataStream);
        }
        this.policyToIndices = Maps.newHashMapWithExpectedSize((int)expectedSize);
        for (IndexMetadata indexMetadata : metadata.indices().values()) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            if (!this.doesPolicyMatchAnyName(policyName, requestedPolicyNames)) continue;
            this.policyToIndices.computeIfAbsent(policyName, k -> new ArrayList()).add(indexMetadata.getIndex().getName());
        }
    }

    public ItemUsage retrieveCalculatedUsage(String policyName) {
        return new ItemUsage((Collection)this.policyToIndices.getOrDefault(policyName, List.of()), (Collection)this.policyToDataStreams.getOrDefault(policyName, List.of()), (Collection)this.policyToTemplates.getOrDefault(policyName, List.of()));
    }

    private boolean doesPolicyMatchAnyName(String policyName, List<String> names) {
        for (String name : names) {
            if (!Regex.simpleMatch((String)name, (String)policyName)) continue;
            return true;
        }
        return false;
    }
}

