/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;

public class DeprecatedIndexPredicate {
    public static final IndexVersion MINIMUM_WRITEABLE_VERSION_AFTER_UPGRADE = IndexVersions.V_8_0_0;

    public static Predicate<Index> getReindexRequiredPredicate(Metadata metadata, boolean filterToBlockedStatus, boolean includeSystem) {
        return index -> {
            IndexMetadata indexMetadata = metadata.index(index);
            return DeprecatedIndexPredicate.reindexRequired(indexMetadata, filterToBlockedStatus, includeSystem);
        };
    }

    public static boolean reindexRequired(IndexMetadata indexMetadata, boolean filterToBlockedStatus, boolean includeSystem) {
        return DeprecatedIndexPredicate.creationVersionBeforeMinimumWritableVersion(indexMetadata) && (includeSystem || DeprecatedIndexPredicate.isNotSystem(indexMetadata)) && DeprecatedIndexPredicate.isNotSearchableSnapshot(indexMetadata) && DeprecatedIndexPredicate.matchBlockedStatus(indexMetadata, filterToBlockedStatus);
    }

    public static boolean reindexRequiredForTransportVersion(IndexMetadata indexMetadata, boolean filterToBlockedStatus, boolean includeSystem) {
        return DeprecatedIndexPredicate.transportVersionBeforeCurrentMinorRelease(indexMetadata) && (includeSystem || DeprecatedIndexPredicate.isNotSystem(indexMetadata)) && DeprecatedIndexPredicate.isNotSearchableSnapshot(indexMetadata) && DeprecatedIndexPredicate.matchBlockedStatus(indexMetadata, filterToBlockedStatus);
    }

    public static List<String> reindexRequiredForPecolatorFields(IndexMetadata indexMetadata, boolean filterToBlockedStatus, boolean includeSystem) {
        ArrayList<String> percolatorIncompatibleFieldMappings = new ArrayList<String>();
        if (DeprecatedIndexPredicate.reindexRequiredForTransportVersion(indexMetadata, filterToBlockedStatus, includeSystem) && indexMetadata.mapping() != null) {
            percolatorIncompatibleFieldMappings.addAll(DeprecatedIndexPredicate.findInPropertiesRecursively(indexMetadata.mapping().type(), indexMetadata.mapping().sourceAsMap(), property -> "percolator".equals(property.get("type")), (type, entry) -> "Field [" + entry.getKey() + "] is of type [" + indexMetadata.mapping().type() + "]", "", ""));
        }
        return percolatorIncompatibleFieldMappings;
    }

    private static boolean isNotSystem(IndexMetadata indexMetadata) {
        return !indexMetadata.isSystem();
    }

    private static boolean isNotSearchableSnapshot(IndexMetadata indexMetadata) {
        return !indexMetadata.isSearchableSnapshot();
    }

    private static boolean creationVersionBeforeMinimumWritableVersion(IndexMetadata metadata) {
        return metadata.getCreationVersion().before((VersionId)MINIMUM_WRITEABLE_VERSION_AFTER_UPGRADE);
    }

    private static boolean matchBlockedStatus(IndexMetadata indexMetadata, boolean filterToBlockedStatus) {
        return (Boolean)MetadataIndexStateService.VERIFIED_READ_ONLY_SETTING.get(indexMetadata.getSettings()) == filterToBlockedStatus;
    }

    private static boolean transportVersionBeforeCurrentMinorRelease(IndexMetadata indexMetadata) {
        return indexMetadata.getTransportVersion().id() / 1000 < TransportVersion.current().id() / 1000;
    }

    public static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter, String fieldBeginMarker, String fieldEndMarker) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + fieldEndMarker);
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + fieldEndMarker);
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(DeprecatedIndexPredicate.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(DeprecatedIndexPredicate.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
        }
        return issues;
    }
}

