/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.license.ClusterStateLicenseService;
import org.elasticsearch.license.GetBasicStatusAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetTrialStatusAction;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.PostStartBasicAction;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.RestDeleteLicenseAction;
import org.elasticsearch.license.RestGetBasicStatus;
import org.elasticsearch.license.RestGetFeatureUsageAction;
import org.elasticsearch.license.RestGetLicenseAction;
import org.elasticsearch.license.RestGetTrialStatus;
import org.elasticsearch.license.RestPostStartBasicLicense;
import org.elasticsearch.license.RestPostStartTrialLicense;
import org.elasticsearch.license.RestPutLicenseAction;
import org.elasticsearch.license.TransportDeleteLicenseAction;
import org.elasticsearch.license.TransportGetBasicStatusAction;
import org.elasticsearch.license.TransportGetFeatureUsageAction;
import org.elasticsearch.license.TransportGetLicenseAction;
import org.elasticsearch.license.TransportGetTrialStatusAction;
import org.elasticsearch.license.TransportPostStartBasicAction;
import org.elasticsearch.license.TransportPostStartTrialAction;
import org.elasticsearch.license.TransportPutLicenseAction;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.license.internal.MutableLicenseService;
import org.elasticsearch.license.internal.XPackLicenseStatus;
import org.elasticsearch.node.PluginComponentBinding;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.snapshots.sourceonly.SourceOnlySnapshotRepository;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.cluster.routing.allocation.mapper.DataTierFieldMapper;
import org.elasticsearch.xpack.core.HealthApiUsageTransportAction;
import org.elasticsearch.xpack.core.RemoteClusterUsageTransportAction;
import org.elasticsearch.xpack.core.XPackClientPlugin;
import org.elasticsearch.xpack.core.action.DataStreamInfoTransportAction;
import org.elasticsearch.xpack.core.action.DataStreamLifecycleUsageTransportAction;
import org.elasticsearch.xpack.core.action.DataStreamUsageTransportAction;
import org.elasticsearch.xpack.core.action.TransportXPackInfoAction;
import org.elasticsearch.xpack.core.action.TransportXPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.async.TransportDeleteAsyncResultAction;
import org.elasticsearch.xpack.core.datatiers.DataTiersInfoTransportAction;
import org.elasticsearch.xpack.core.datatiers.DataTiersUsageTransportAction;
import org.elasticsearch.xpack.core.datatiers.NodesDataTiersUsageTransportAction;
import org.elasticsearch.xpack.core.rest.action.RestXPackInfoAction;
import org.elasticsearch.xpack.core.rest.action.RestXPackUsageAction;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationReloader;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.action.TransportTermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.rest.RestTermsEnumAction;

public class XPackPlugin
extends XPackClientPlugin
implements ExtensiblePlugin,
RepositoryPlugin,
EnginePlugin,
ClusterPlugin,
MapperPlugin {
    private static final DeprecationLogger deprecationLogger;
    public static final String ASYNC_RESULTS_INDEX = ".async-search";
    public static final String XPACK_INSTALLED_NODE_ATTR = "xpack.installed";
    private static final Logger logger;
    protected final Settings settings;
    private static final SetOnce<SSLService> sslService;
    private static SetOnce<LongSupplier> epochMillisSupplier;
    private static SetOnce<XPackLicenseState> licenseState;
    private static SetOnce<LicenseService> licenseService;

    public XPackPlugin(Settings settings) {
        this.settings = settings;
        licenseState = new SetOnce();
        licenseService = new SetOnce();
        epochMillisSupplier = new SetOnce();
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LongSupplier getEpochMillisSupplier() {
        return XPackPlugin.getSharedEpochMillisSupplier();
    }

    protected void setSslService(SSLService sslService) {
        XPackPlugin.sslService.set((Object)sslService);
    }

    protected void setLicenseService(LicenseService licenseService) {
        XPackPlugin.licenseService.set((Object)licenseService);
    }

    protected void setLicenseState(XPackLicenseState licenseState) {
        XPackPlugin.licenseState.set((Object)licenseState);
    }

    protected void setEpochMillisSupplier(LongSupplier epochMillisSupplier) {
        XPackPlugin.epochMillisSupplier.set((Object)epochMillisSupplier);
    }

    public static SSLService getSharedSslService() {
        SSLService ssl = (SSLService)sslService.get();
        if (ssl == null) {
            throw new IllegalStateException("SSL Service is not constructed yet");
        }
        return ssl;
    }

    public static LicenseService getSharedLicenseService() {
        return (LicenseService)licenseService.get();
    }

    public static XPackLicenseState getSharedLicenseState() {
        return (XPackLicenseState)licenseState.get();
    }

    public static LongSupplier getSharedEpochMillisSupplier() {
        return (LongSupplier)epochMillisSupplier.get();
    }

    public static void checkReadyForXPackCustomMetadata(ClusterState clusterState) {
        if (XPackPlugin.alreadyContainsXPackCustomMetadata(clusterState)) {
            return;
        }
        List<DiscoveryNode> notReadyNodes = XPackPlugin.nodesNotReadyForXPackCustomMetadata(clusterState);
        if (!notReadyNodes.isEmpty()) {
            throw new IllegalStateException("The following nodes are not ready yet for enabling x-pack custom metadata: " + notReadyNodes);
        }
    }

    public static boolean isReadyForXPackCustomMetadata(ClusterState clusterState) {
        return XPackPlugin.alreadyContainsXPackCustomMetadata(clusterState) || XPackPlugin.nodesNotReadyForXPackCustomMetadata(clusterState).isEmpty();
    }

    public static List<DiscoveryNode> nodesNotReadyForXPackCustomMetadata(ClusterState clusterState) {
        List<DiscoveryNode> notReadyNodes = clusterState.nodes().stream().filter(node -> {
            String xpackInstalledAttr = node.getAttributes().getOrDefault(XPACK_INSTALLED_NODE_ATTR, "false");
            return !Booleans.parseBoolean((String)xpackInstalledAttr);
        }).collect(Collectors.toList());
        return notReadyNodes;
    }

    private static boolean alreadyContainsXPackCustomMetadata(ClusterState clusterState) {
        Metadata metadata = clusterState.metadata();
        return metadata.custom("licenses") != null || metadata.custom("ml") != null || metadata.custom("watcher") != null || !RoleMappingMetadata.getFromClusterState(clusterState).isEmpty() || clusterState.custom("security_tokens") != null || metadata.custom("transform") != null;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Map.of("_tier", DataTierFieldMapper.PARSER);
    }

    public Settings additionalSettings() {
        String xpackInstalledNodeAttrSetting = "node.attr.xpack.installed";
        if (this.settings.get("node.attr.xpack.installed") != null) {
            throw new IllegalArgumentException("Directly setting [node.attr.xpack.installed] is not permitted");
        }
        return Settings.builder().put(super.additionalSettings()).put("node.attr.xpack.installed", "true").build();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ArrayList<Object> components = new ArrayList<Object>();
        SSLService sslService = this.createSSLService(services.environment(), services.resourceWatcherService());
        LicenseService licenseService = this.getLicenseService();
        if (licenseService == null) {
            licenseService = new ClusterStateLicenseService(this.settings, services.threadPool(), services.clusterService(), this.getClock(), this.getLicenseState(), services.featureService());
            this.setLicenseService(licenseService);
        }
        this.setEpochMillisSupplier(() -> ((ThreadPool)services.threadPool()).absoluteTimeInMillis());
        components.add(sslService);
        components.add(new PluginComponentBinding(MutableLicenseService.class, (Object)licenseService));
        components.add(new PluginComponentBinding(LicenseService.class, (Object)licenseService));
        components.add(this.getLicenseState());
        return components;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler(XPackInfoAction.INSTANCE, this.getInfoAction()));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageAction.INSTANCE, this.getUsageAction()));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PutLicenseAction.INSTANCE, TransportPutLicenseAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetLicenseAction.INSTANCE, TransportGetLicenseAction.class));
        actions.add(new ActionPlugin.ActionHandler(TransportDeleteLicenseAction.TYPE, TransportDeleteLicenseAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PostStartTrialAction.INSTANCE, TransportPostStartTrialAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetTrialStatusAction.INSTANCE, TransportGetTrialStatusAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PostStartBasicAction.INSTANCE, TransportPostStartBasicAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetBasicStatusAction.INSTANCE, TransportGetBasicStatusAction.class));
        actions.add(new ActionPlugin.ActionHandler(TransportGetFeatureUsageAction.TYPE, TransportGetFeatureUsageAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)TermsEnumAction.INSTANCE, TransportTermsEnumAction.class));
        actions.add(new ActionPlugin.ActionHandler(TransportDeleteAsyncResultAction.TYPE, TransportDeleteAsyncResultAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.DATA_TIERS, DataTiersInfoTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.DATA_TIERS, DataTiersUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.DATA_STREAMS, DataStreamUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.DATA_STREAMS, DataStreamInfoTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.DATA_STREAM_LIFECYCLE, DataStreamLifecycleUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.HEALTH, HealthApiUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.REMOTE_CLUSTERS, RemoteClusterUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(NodesDataTiersUsageTransportAction.TYPE, NodesDataTiersUsageTransportAction.class));
        return actions;
    }

    protected Class<? extends TransportAction<XPackUsageRequest, XPackUsageResponse>> getUsageAction() {
        return TransportXPackUsageAction.class;
    }

    protected Class<? extends TransportAction<XPackInfoRequest, XPackInfoResponse>> getInfoAction() {
        return TransportXPackInfoAction.class;
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestXPackInfoAction());
        handlers.add((RestHandler)new RestXPackUsageAction());
        handlers.add((RestHandler)new RestTermsEnumAction());
        handlers.add((RestHandler)new RestGetLicenseAction());
        handlers.add((RestHandler)new RestPutLicenseAction());
        handlers.add((RestHandler)new RestDeleteLicenseAction());
        handlers.add((RestHandler)new RestGetTrialStatus());
        handlers.add((RestHandler)new RestGetBasicStatus());
        handlers.add((RestHandler)new RestPostStartTrialLicense());
        handlers.add((RestHandler)new RestPostStartBasicLicense());
        handlers.add((RestHandler)new RestGetFeatureUsageAction());
        return handlers;
    }

    public static Path resolveConfigFile(Environment env, String name) {
        Path legacyConfig;
        Path config = env.configDir().resolve(name);
        if (!Files.exists(config, new LinkOption[0]) && Files.exists(legacyConfig = env.configDir().resolve("x-pack").resolve(name), new LinkOption[0])) {
            deprecationLogger.warn(DeprecationCategory.OTHER, "config_file_path", "Config file [" + name + "] is in a deprecated location. Move from " + legacyConfig.toString() + " to " + config.toString(), new Object[0]);
            return legacyConfig;
        }
        return config;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics) {
        return Collections.singletonMap("source", SourceOnlySnapshotRepository.newRepositoryFactory());
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(SourceOnlySnapshotRepository.SOURCE_ONLY)).booleanValue() && !indexSettings.getIndexMetadata().isSearchableSnapshot()) {
            return Optional.of(SourceOnlySnapshotRepository.getEngineFactory());
        }
        return Optional.empty();
    }

    @Override
    public List<Setting<?>> getSettings() {
        List<Setting<?>> settings = super.getSettings();
        settings.add(SourceOnlySnapshotRepository.SOURCE_ONLY);
        if (XPackPlugin.getSharedLicenseService() == null) {
            settings.add(LicenseSettings.SELF_GENERATED_LICENSE_TYPE);
            settings.add(LicenseSettings.ALLOWED_LICENSE_TYPES_SETTING);
        }
        return settings;
    }

    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        if (DiscoveryNode.isStateless((Settings)settings)) {
            return List.of();
        }
        return Collections.singleton(DataTierAllocationDecider.INSTANCE);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return List.of();
        }
        return Collections.singleton(new DataTier.DefaultHotAllocationSettingProvider());
    }

    private SSLService createSSLService(Environment environment, ResourceWatcherService resourceWatcherService) {
        Map<String, SslConfiguration> sslConfigurations = SSLService.getSSLConfigurations(environment);
        SSLConfigurationReloader reloader = new SSLConfigurationReloader(resourceWatcherService, sslConfigurations.values());
        SSLService sslService = new SSLService(environment, sslConfigurations);
        reloader.setSSLService(sslService);
        this.setSslService(sslService);
        return sslService;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        List licenseServices = loader.loadExtensions(MutableLicenseService.class);
        if (licenseServices.size() > 1) {
            throw new IllegalStateException(MutableLicenseService.class + " may not have multiple implementations");
        }
        if (licenseServices.size() == 1) {
            MutableLicenseService licenseService = (MutableLicenseService)licenseServices.get(0);
            logger.debug("Loaded implementation [{}] for interface MutableLicenseService", (Object)licenseService.getClass().getCanonicalName());
            this.setLicenseService(licenseService);
            this.setLicenseState(new XPackLicenseState(() -> this.getEpochMillisSupplier().getAsLong(), LicenseUtils.getXPackLicenseStatus(licenseService.getLicense(), this.getClock())));
        } else {
            this.setLicenseState(new XPackLicenseState(() -> this.getEpochMillisSupplier().getAsLong(), new XPackLicenseStatus(License.OperationMode.TRIAL, true, null)));
        }
    }

    static {
        block3: {
            deprecationLogger = DeprecationLogger.getLogger(XPackPlugin.class);
            logger = LogManager.getLogger(XPackPlugin.class);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Class.forName("com.unboundid.util.Debug");
                            Class.forName("com.unboundid.ldap.sdk.LDAPConnectionOptions");
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            catch (ExceptionInInitializerError bogus) {
                if (bogus.getCause() instanceof SecurityException) break block3;
                throw bogus;
            }
        }
        sslService = new SetOnce();
        epochMillisSupplier = new SetOnce();
        licenseState = new SetOnce();
        licenseService = new SetOnce();
    }
}

