/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.model;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerServiceSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerTaskSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemas;

public class SageMakerConfiguration
implements CheckedSupplier<Map<String, SettingsConfiguration>, RuntimeException> {
    private final SageMakerSchemas schemas;

    public SageMakerConfiguration(SageMakerSchemas schemas) {
        this.schemas = schemas;
    }

    public Map<String, SettingsConfiguration> get() {
        return Stream.of(AwsSecretSettings.configuration(this.schemas.supportedTaskTypes()), SageMakerServiceSettings.configuration(this.schemas.supportedTaskTypes()), SageMakerTaskSettings.configuration(this.schemas.supportedTaskTypes())).flatMap(Function.identity()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

