/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.TruncatingRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.OpenAiResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.action.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.openai.request.OpenAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.openai.request.OpenAiUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiEmbeddingsResponseEntity;

public class OpenAiActionCreator
implements OpenAiActionVisitor {
    public static final String COMPLETION_ERROR_PREFIX = "OpenAI chat completions";
    public static final String USER_ROLE = "user";
    static final ResponseHandler COMPLETION_HANDLER = new OpenAiChatCompletionResponseHandler("openai completion", OpenAiChatCompletionResponseEntity::fromResponse);
    public static final ResponseHandler EMBEDDINGS_HANDLER = new OpenAiResponseHandler("openai text embedding", OpenAiEmbeddingsResponseEntity::fromResponse, false);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public OpenAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(OpenAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        OpenAiEmbeddingsModel overriddenModel = OpenAiEmbeddingsModel.of(model, taskSettings);
        TruncatingRequestManager manager = new TruncatingRequestManager(this.serviceComponents.threadPool(), overriddenModel, EMBEDDINGS_HANDLER, truncationResult -> new OpenAiEmbeddingsRequest(this.serviceComponents.truncator(), (Truncator.TruncationResult)truncationResult, overriddenModel), overriddenModel.getServiceSettings().maxInputTokens());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("OpenAI embeddings");
        return new SenderExecutableAction(this.sender, manager, errorMessage);
    }

    @Override
    public ExecutableAction create(OpenAiChatCompletionModel model, Map<String, Object> taskSettings) {
        OpenAiChatCompletionModel overriddenModel = OpenAiChatCompletionModel.of(model, taskSettings);
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), overriddenModel, COMPLETION_HANDLER, inputs -> new OpenAiUnifiedChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), overriddenModel), ChatCompletionInput.class);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(COMPLETION_ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }
}

