/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;

public class JinaAIRerankResponseEntity {
    public static InferenceServiceResults fromResponse(HttpResult response) throws IOException {
        try (XContentParser p = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            RankedDocsResults rankedDocsResults = ((Response)Response.PARSER.apply(p, null)).toRankedDocsResults();
            return rankedDocsResults;
        }
    }

    private static Document parseDocument(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            return new Document(((DocumentObject)DocumentObject.PARSER.apply(parser, null)).text());
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new Document(parser.text());
        }
        throw new XContentParseException(parser.getTokenLocation(), "Expected an object or string for document field, but got: " + token);
    }

    private record Response(List<ResultItem> results) {
        public static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser(Response.class.getSimpleName(), true, args -> new Response((List)args[0]));

        public RankedDocsResults toRankedDocsResults() {
            List<RankedDocsResults.RankedDoc> rankedDocs = this.results.stream().map(item -> new RankedDocsResults.RankedDoc(item.index(), item.relevanceScore(), item.document() != null ? item.document().text() : null)).toList();
            return new RankedDocsResults(rankedDocs);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ResultItem.PARSER.apply(arg_0, arg_1), new ParseField("results", new String[0]));
        }
    }

    private record Document(String text) {
    }

    private record DocumentObject(String text) {
        public static final ConstructingObjectParser<DocumentObject, Void> PARSER = new ConstructingObjectParser(DocumentObject.class.getSimpleName(), true, args -> new DocumentObject((String)args[0]));

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("text", new String[0]));
        }
    }

    private record ResultItem(int index, float relevanceScore, @Nullable Document document) {
        public static final ConstructingObjectParser<ResultItem, Void> PARSER = new ConstructingObjectParser(ResultItem.class.getSimpleName(), true, args -> new ResultItem((Integer)args[0], ((Float)args[1]).floatValue(), (Document)args[2]));

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("relevance_score", new String[0]));
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> JinaAIRerankResponseEntity.parseDocument(p), new ParseField("document", new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
        }
    }
}

