/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingType;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsTaskSettings;

public record JinaAIEmbeddingsRequestEntity(List<String> input, InputType inputType, JinaAIEmbeddingsTaskSettings taskSettings, @Nullable String model, @Nullable JinaAIEmbeddingType embeddingType, Integer dimensions, boolean dimensionsSetByUser) implements ToXContentObject
{
    private static final String SEARCH_DOCUMENT = "retrieval.passage";
    private static final String SEARCH_QUERY = "retrieval.query";
    private static final String CLUSTERING = "separation";
    private static final String CLASSIFICATION = "classification";
    private static final String INPUT_FIELD = "input";
    private static final String MODEL_FIELD = "model";
    public static final String TASK_TYPE_FIELD = "task";
    static final String EMBEDDING_TYPE_FIELD = "embedding_type";
    static final String DIMENSIONS_FIELD = "dimensions";

    public JinaAIEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
        Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INPUT_FIELD, this.input);
        builder.field(MODEL_FIELD, this.model);
        if (this.embeddingType != null) {
            builder.field(EMBEDDING_TYPE_FIELD, this.embeddingType.toRequestString());
        }
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field(TASK_TYPE_FIELD, JinaAIEmbeddingsRequestEntity.convertToString(this.inputType));
        } else if (InputType.isSpecified((InputType)this.taskSettings.getInputType())) {
            builder.field(TASK_TYPE_FIELD, JinaAIEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType()));
        }
        if (this.dimensionsSetByUser && this.dimensions != null) {
            builder.field(DIMENSIONS_FIELD, this.dimensions);
        }
        builder.endObject();
        return builder;
    }

    public static String convertToString(InputType inputType) {
        return switch (inputType) {
            case InputType.INGEST, InputType.INTERNAL_INGEST -> SEARCH_DOCUMENT;
            case InputType.SEARCH, InputType.INTERNAL_SEARCH -> SEARCH_QUERY;
            case InputType.CLASSIFICATION -> CLASSIFICATION;
            case InputType.CLUSTERING -> CLUSTERING;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

