/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.response;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.huggingface.request.rerank.HuggingFaceRerankRequest;

public class HuggingFaceRerankResponseEntity {
    public static RankedDocsResults fromResponse(HuggingFaceRerankRequest request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            List<RankedDocsResults.RankedDoc> rankedDocs = HuggingFaceRerankResponseEntity.doParse(jsonParser);
            Stream<RankedDocsResults.RankedDoc> rankedDocsByRelevanceStream = rankedDocs.stream().sorted(Comparator.comparingDouble(RankedDocsResults.RankedDoc::relevanceScore).reversed());
            Stream<RankedDocsResults.RankedDoc> rankedDocStreamTopN = request.getTopN() == null ? rankedDocsByRelevanceStream : rankedDocsByRelevanceStream.limit(request.getTopN().intValue());
            RankedDocsResults rankedDocsResults = new RankedDocsResults(rankedDocStreamTopN.toList());
            return rankedDocsResults;
        }
    }

    private static List<RankedDocsResults.RankedDoc> doParse(XContentParser parser) throws IOException {
        return XContentParserUtils.parseList((XContentParser)parser, (listParser, index) -> {
            RankedDocEntry parsedRankedDoc = RankedDocEntry.parse(parser);
            return new RankedDocsResults.RankedDoc(parsedRankedDoc.index.intValue(), parsedRankedDoc.score.floatValue(), parsedRankedDoc.text);
        });
    }

    private record RankedDocEntry(Integer index, Float score, @Nullable String text) {
        private static final ParseField TEXT = new ParseField("text", new String[0]);
        private static final ParseField SCORE = new ParseField("score", new String[0]);
        private static final ParseField INDEX = new ParseField("index", new String[0]);
        private static final ConstructingObjectParser<RankedDocEntry, Void> PARSER = new ConstructingObjectParser("hugging_face_rerank_response", true, args -> new RankedDocEntry((int)((Integer)args[0]), Float.valueOf(((Float)args[1]).floatValue()), (String)args[2]));

        public static RankedDocEntry parse(XContentParser parser) {
            return (RankedDocEntry)PARSER.apply(parser, null);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), INDEX);
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), SCORE);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TEXT);
        }
    }
}

