/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.completion;

import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.action.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.huggingface.completion.HuggingFaceChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class HuggingFaceChatCompletionModel
extends HuggingFaceModel {
    public static HuggingFaceChatCompletionModel of(HuggingFaceChatCompletionModel model, UnifiedCompletionRequest request) {
        HuggingFaceChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        HuggingFaceChatCompletionServiceSettings overriddenServiceSettings = new HuggingFaceChatCompletionServiceSettings(request.model() != null ? request.model() : originalModelServiceSettings.modelId(), originalModelServiceSettings.uri(), originalModelServiceSettings.rateLimitSettings());
        return new HuggingFaceChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    public HuggingFaceChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, HuggingFaceChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    HuggingFaceChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, HuggingFaceChatCompletionServiceSettings serviceSettings, @Nullable DefaultSecretSettings secretSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings), new ModelSecrets((SecretSettings)secretSettings), serviceSettings, secretSettings);
    }

    public HuggingFaceChatCompletionServiceSettings getServiceSettings() {
        return (HuggingFaceChatCompletionServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(HuggingFaceActionVisitor creator) {
        return creator.create(this);
    }

    @Override
    public Integer getTokenLimit() {
        throw new UnsupportedOperationException("Token Limit for chat completion is sent in request and not retrieved from the model");
    }
}

