/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.action;

import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRequestManager;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceResponseHandler;
import org.elasticsearch.xpack.inference.services.huggingface.action.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.huggingface.completion.HuggingFaceChatCompletionModel;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserModel;
import org.elasticsearch.xpack.inference.services.huggingface.embeddings.HuggingFaceEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.huggingface.request.completion.HuggingFaceUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.huggingface.request.rerank.HuggingFaceRerankRequest;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankModel;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceElserResponseEntity;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceRerankResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class HuggingFaceActionCreator
implements HuggingFaceActionVisitor {
    private static final String FAILED_TO_SEND_REQUEST_ERROR_MESSAGE = "Failed to send Hugging Face %s request from inference entity id [%s]";
    private static final String INVALID_REQUEST_TYPE_MESSAGE = "Invalid request type: expected HuggingFace %s request but got %s";
    public static final String COMPLETION_ERROR_PREFIX = "Hugging Face completions";
    static final String USER_ROLE = "user";
    static final ResponseHandler COMPLETION_HANDLER = new OpenAiChatCompletionResponseHandler("hugging face completion", OpenAiChatCompletionResponseEntity::fromResponse);
    private static final ResponseHandler RERANK_HANDLER = new HuggingFaceResponseHandler("hugging face rerank", (request, response) -> {
        if (!(request instanceof HuggingFaceRerankRequest)) {
            String errorMessage = Strings.format((String)INVALID_REQUEST_TYPE_MESSAGE, (Object[])new Object[]{"RERANK", request != null ? request.getClass().getSimpleName() : "null"});
            throw new IllegalArgumentException(errorMessage);
        }
        return HuggingFaceRerankResponseEntity.fromResponse((HuggingFaceRerankRequest)request, response);
    });
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public HuggingFaceActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(HuggingFaceRerankModel model) {
        HuggingFaceRerankModel overriddenModel = HuggingFaceRerankModel.of(model, model.getTaskSettings());
        GenericRequestManager<QueryAndDocsInputs> manager = new GenericRequestManager<QueryAndDocsInputs>(this.serviceComponents.threadPool(), overriddenModel, RERANK_HANDLER, inputs -> new HuggingFaceRerankRequest(inputs.getQuery(), inputs.getChunks(), inputs.getReturnDocuments(), inputs.getTopN(), model), QueryAndDocsInputs.class);
        String errorMessage = HuggingFaceActionCreator.buildErrorMessage(TaskType.RERANK, model.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, manager, errorMessage);
    }

    @Override
    public ExecutableAction create(HuggingFaceEmbeddingsModel model) {
        HuggingFaceResponseHandler responseHandler = new HuggingFaceResponseHandler("hugging face text embeddings", HuggingFaceEmbeddingsResponseEntity::fromResponse);
        HuggingFaceRequestManager requestCreator = HuggingFaceRequestManager.of(model, responseHandler, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = HuggingFaceActionCreator.buildErrorMessage(TaskType.TEXT_EMBEDDING, model.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, requestCreator, errorMessage);
    }

    @Override
    public ExecutableAction create(HuggingFaceElserModel model) {
        HuggingFaceResponseHandler responseHandler = new HuggingFaceResponseHandler("hugging face elser", HuggingFaceElserResponseEntity::fromResponse);
        HuggingFaceRequestManager requestCreator = HuggingFaceRequestManager.of(model, responseHandler, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = HuggingFaceActionCreator.buildErrorMessage(TaskType.SPARSE_EMBEDDING, model.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, requestCreator, errorMessage);
    }

    @Override
    public ExecutableAction create(HuggingFaceChatCompletionModel model) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), model, COMPLETION_HANDLER, inputs -> new HuggingFaceUnifiedChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), model), ChatCompletionInput.class);
        String errorMessage = HuggingFaceActionCreator.buildErrorMessage(TaskType.COMPLETION, model.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)FAILED_TO_SEND_REQUEST_ERROR_MESSAGE, (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

