/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public final class ElasticInferenceServiceSettingsUtils {
    public static final int MAX_BATCH_SIZE_UPPER_BOUND = 512;
    public static final String MAX_BATCH_SIZE = "max_batch_size";
    public static final TransportVersion INFERENCE_API_EIS_MAX_BATCH_SIZE = TransportVersion.fromName((String)"inference_api_eis_max_batch_size");

    private ElasticInferenceServiceSettingsUtils() {
    }

    public static Integer parseMaxBatchSize(Map<String, Object> serviceSettings, ValidationException validationException) {
        return ServiceUtils.extractOptionalPositiveIntegerBetween(serviceSettings, MAX_BATCH_SIZE, 1, 512, "service_settings", validationException);
    }
}

