/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.request;

import org.apache.http.Header;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiSecretSettings;

public interface AzureOpenAiRequest
extends Request {
    public static final String MISSING_AUTHENTICATION_ERROR_MESSAGE = "The request does not have any authentication methods set. One of [%s] or [%s] is required.";

    public static void decorateWithAuthHeader(HttpPost httpPost, AzureOpenAiSecretSettings secretSettings) {
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        SecureString entraId = secretSettings.entraId();
        SecureString apiKey = secretSettings.apiKey();
        if (entraId != null && !entraId.isEmpty()) {
            httpPost.setHeader(RequestUtils.createAuthBearerHeader(entraId));
        } else if (apiKey != null && !apiKey.isEmpty()) {
            httpPost.setHeader((Header)new BasicHeader("api-key", apiKey.toString()));
        } else {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(Strings.format((String)MISSING_AUTHENTICATION_ERROR_MESSAGE, (Object[])new Object[]{"api_key", "entra_id"}));
            throw validationException;
        }
    }
}

