/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionModel;
import org.elasticsearch.xpack.inference.services.azureopenai.request.AzureOpenAiCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.azureopenai.request.AzureOpenAiRequest;

public class AzureOpenAiCompletionRequest
implements AzureOpenAiRequest {
    private final List<String> input;
    private final URI uri;
    private final AzureOpenAiCompletionModel model;
    private final boolean stream;

    public AzureOpenAiCompletionRequest(List<String> input, AzureOpenAiCompletionModel model, boolean stream) {
        this.input = input;
        this.model = Objects.requireNonNull(model);
        this.uri = model.getUri();
        this.stream = stream;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        String requestEntity = Strings.toString((ToXContent)new AzureOpenAiCompletionRequestEntity(this.input, this.model.getTaskSettings().user(), this.isStreaming()));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        AzureOpenAiRequest.decorateWithAuthHeader(httpPost, this.model.getSecretSettings());
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public boolean isStreaming() {
        return this.stream;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

