/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.response.embeddings;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.AmazonBedrockResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AmazonBedrockEmbeddingsResponse
extends AmazonBedrockResponse {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Amazon Bedrock embeddings response";
    private final InvokeModelResponse result;

    public AmazonBedrockEmbeddingsResponse(InvokeModelResponse invokeModelResult) {
        this.result = invokeModelResult;
    }

    @Override
    public InferenceServiceResults accept(AmazonBedrockRequest request) {
        if (request instanceof AmazonBedrockEmbeddingsRequest) {
            AmazonBedrockEmbeddingsRequest asEmbeddingsRequest = (AmazonBedrockEmbeddingsRequest)request;
            return AmazonBedrockEmbeddingsResponse.fromResponse(this.result, asEmbeddingsRequest.provider());
        }
        throw new ElasticsearchException("unexpected request type [" + request.getClass() + "]", new Object[0]);
    }

    public static TextEmbeddingFloatResults fromResponse(InvokeModelResponse response, AmazonBedrockProvider provider) {
        TextEmbeddingFloatResults textEmbeddingFloatResults;
        block8: {
            Charset charset = StandardCharsets.UTF_8;
            String bodyText = String.valueOf(charset.decode(response.body().asByteBuffer()));
            XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
            XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, bodyText);
            try {
                jsonParser.nextToken();
                XContentParser.Token token = jsonParser.currentToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
                List<TextEmbeddingFloatResults.Embedding> embeddingList = AmazonBedrockEmbeddingsResponse.parseEmbeddings(jsonParser, provider);
                textEmbeddingFloatResults = new TextEmbeddingFloatResults(embeddingList);
                if (jsonParser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException((Throwable)e);
                }
            }
            jsonParser.close();
        }
        return textEmbeddingFloatResults;
    }

    private static List<TextEmbeddingFloatResults.Embedding> parseEmbeddings(XContentParser jsonParser, AmazonBedrockProvider provider) throws IOException {
        switch (provider) {
            case AMAZONTITAN: {
                return AmazonBedrockEmbeddingsResponse.parseTitanEmbeddings(jsonParser);
            }
            case COHERE: {
                return AmazonBedrockEmbeddingsResponse.parseCohereEmbeddings(jsonParser);
            }
        }
        throw new IOException("Unsupported provider [" + provider + "]");
    }

    private static List<TextEmbeddingFloatResults.Embedding> parseTitanEmbeddings(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "embedding", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        TextEmbeddingFloatResults.Embedding embeddingValues = TextEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
        return List.of(embeddingValues);
    }

    private static List<TextEmbeddingFloatResults.Embedding> parseCohereEmbeddings(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, AmazonBedrockEmbeddingsResponse::parseCohereEmbeddingsListItem);
        return embeddingList;
    }

    private static TextEmbeddingFloatResults.Embedding parseCohereEmbeddingsListItem(XContentParser parser) throws IOException {
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        return TextEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
    }
}

