/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.response.completion;

import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.AmazonBedrockResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;

public class AmazonBedrockChatCompletionResponse
extends AmazonBedrockResponse {
    private final ConverseResponse result;

    public AmazonBedrockChatCompletionResponse(ConverseResponse responseResult) {
        this.result = responseResult;
    }

    @Override
    public InferenceServiceResults accept(AmazonBedrockRequest request) {
        if (request instanceof AmazonBedrockChatCompletionRequest) {
            AmazonBedrockChatCompletionRequest asChatCompletionRequest = (AmazonBedrockChatCompletionRequest)request;
            return AmazonBedrockChatCompletionResponse.fromResponse(this.result);
        }
        throw new ElasticsearchException("unexpected request type [" + request.getClass() + "]", new Object[0]);
    }

    public static ChatCompletionResults fromResponse(ConverseResponse response) {
        List<ChatCompletionResults.Result> resultTexts = response.output().message().content().stream().map(ContentBlock::text).map(ChatCompletionResults.Result::new).toList();
        return new ChatCompletionResults(resultTexts);
    }
}

